/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleSettingsMenu;
import ua.mcchickenstudio.opencreative.commands.ChatCommand;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetPlayer;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class QuitListener
implements Listener {
    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        player.spigot().respawn();
        final Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorldName(player.getWorld().getName().replace("dev", ""));
        if (planet != null) {
            new QuitEvent(player).callEvent();
            PlanetPlayer planetPlayer = planet.getWorldPlayers().getPlanetPlayer(player);
            if (planetPlayer != null) {
                planetPlayer.save();
            }
            planet.getWorldPlayers().unregisterPlayer(player);
            planet.getInformation().updateIconAsync();
            new BukkitRunnable(this){

                public void run() {
                    if (planet.getOnline() == 0) {
                        planet.getTerritory().unload();
                    }
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        }
        player.setGameMode(GameMode.ADVENTURE);
        PlayerUtils.teleportToLobby(player);
        ChatListener.confirmation.remove(player);
        ChatCommand.creativeChatOff.remove(player);
        ModuleSettingsMenu.removeFromCurrentEditing(player);
        PlayerUtils.removeFromPermissionsMap(player);
        CooldownUtils.clearPlayerCooldowns(player);
    }
}

