/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityResurrectEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerTotemRespawnEvent;
import ua.mcchickenstudio.opencreative.listeners.player.DeathListener;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public final class RespawnListener
implements Listener {
    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        if (!DeathListener.deathLocations.containsKey(event.getPlayer())) {
            return;
        }
        Location deathLocation = DeathListener.deathLocations.get(event.getPlayer());
        event.setRespawnLocation(deathLocation);
        DeathListener.deathLocations.remove(event.getPlayer());
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(event.getPlayer());
        if (planet != null) {
            Sounds.PLAYER_RESPAWN.play((Audience)event.getPlayer());
            if (planet.isOwner(event.getPlayer())) {
                ItemStack worldSettingsItem = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                if (!event.getPlayer().getInventory().contains(worldSettingsItem)) {
                    event.getPlayer().getInventory().setItem(8, worldSettingsItem);
                }
            }
            new ua.mcchickenstudio.opencreative.coding.blocks.events.player.fighting.PlayerRespawnEvent(event.getPlayer()).callEvent();
        }
    }

    @EventHandler
    public void onTotemUsing(EntityResurrectEvent event) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(event.getEntity().getWorld());
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (planet != null) {
                new PlayerTotemRespawnEvent(player).callEvent();
            }
        }
    }
}

