/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.player;

import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.movement.TeleportEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;

public final class TeleportListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onTeleport(PlayerTeleportEvent event) {
        Planet planet;
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.END_PORTAL || event.getCause() == PlayerTeleportEvent.TeleportCause.END_GATEWAY || event.getCause() == PlayerTeleportEvent.TeleportCause.NETHER_PORTAL) {
            event.setCancelled(true);
        }
        if ((planet = OpenCreative.getPlanetsManager().getPlanetByWorld(event.getFrom().getWorld())) != null) {
            if (event.getTo().getWorld().equals((Object)event.getFrom().getWorld())) {
                new TeleportEvent(event.getPlayer()).callEvent();
            } else if (event.getCause() == PlayerTeleportEvent.TeleportCause.SPECTATE || event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL || event.getCause() == PlayerTeleportEvent.TeleportCause.DISMOUNT || event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT || event.getCause() == PlayerTeleportEvent.TeleportCause.EXIT_BED) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onPortalTeleport(PlayerPortalEvent event) {
        event.setCancelled(true);
        event.setCanCreatePortal(false);
    }

    @EventHandler
    public void onPortalTeleport(EntityPortalEvent event) {
        event.setCancelled(true);
        event.setCanCreatePortal(false);
    }

    @EventHandler
    public void onPortalTeleport(EntityPortalEnterEvent event) {
        event.setCancelled(true);
    }

    @EventHandler
    public void onPortalTeleport(EntityInsideBlockEvent event) {
        if (event.getBlock().getType() == Material.END_PORTAL || event.getBlock().getType() == Material.END_GATEWAY) {
            event.setCancelled(true);
        }
    }
}

