/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.listeners.world;

import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.blocks.BlockRedstoneEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedRedstoneEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class RedstoneListener
implements Listener {
    @EventHandler
    public void onBlockRedstone(org.bukkit.event.block.BlockRedstoneEvent event) {
        final Location location = event.getBlock().getLocation();
        final Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(location.getWorld());
        if (planet != null) {
            planet.getLimits().setLastRedstoneOperationsAmount(planet.getLimits().getLastRedstoneOperationsAmount() + 1);
            if (planet.getLimits().getLastRedstoneOperationsAmount() > planet.getLimits().getRedstoneOperationsLimit()) {
                MessageUtils.sendMessageOnce(planet, MessageUtils.getLocaleMessage("world.redstone-limit").replace("%count%", String.valueOf(planet.getLimits().getRedstoneOperationsLimit())), 5);
                if (location.getBlock().getType() == Material.OBSERVER) {
                    new BukkitRunnable(this){

                        public void run() {
                            location.getBlock().setType(Material.AIR);
                        }
                    }.runTaskLater((Plugin)OpenCreative.getPlugin(), 1L);
                } else {
                    location.getBlock().setType(Material.CAVE_AIR);
                }
                planet.getLimits().setLastRedstoneOperationsAmount(0);
                new LimitReachedRedstoneEvent(planet).callEvent();
            } else {
                new BlockRedstoneEvent(planet, event).callEvent();
            }
            if (planet.getLimits().getLastRedstoneOperationsAmount() > 0) {
                new BukkitRunnable(this){

                    public void run() {
                        planet.getLimits().setLastRedstoneOperationsAmount(planet.getLimits().getLastRedstoneOperationsAmount() - 1);
                    }
                }.runTaskLater((Plugin)OpenCreative.getPlugin(), 5L);
            }
        }
    }

    @EventHandler
    public void onPiston(BlockPistonExtendEvent event) {
        if (WorldUtils.isDevPlanet(event.getBlock().getWorld())) {
            event.setCancelled(true);
        }
    }
}

