/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.managers.modules;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodeConfiguration;
import ua.mcchickenstudio.opencreative.coding.CodingBlockParser;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.coding.modules.ModuleSettingsMenu;
import ua.mcchickenstudio.opencreative.events.module.ModuleCreationEvent;
import ua.mcchickenstudio.opencreative.events.module.ModuleDeletionEvent;
import ua.mcchickenstudio.opencreative.events.module.ModuleRegisterEvent;
import ua.mcchickenstudio.opencreative.managers.modules.ModuleManager;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class Moduler
implements ModuleManager {
    private final Set<Module> modules = new HashSet<Module>();

    @Override
    @Nullable
    public Module getModuleById(@NotNull String id) {
        if (id == null) {
            Moduler.$$$reportNull$$$0(0);
        }
        for (Module module : this.modules) {
            if (!String.valueOf(module.getId()).equals(id)) continue;
            return module;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<Module> getModules() {
        return new HashSet<Module>(this.modules);
    }

    @Override
    @NotNull
    public Set<Module> getPlayerModules(@NotNull UUID uuid) {
        if (uuid == null) {
            Moduler.$$$reportNull$$$0(1);
        }
        HashSet<Module> playerModules = new HashSet<Module>();
        for (Module module : this.modules) {
            if (!module.getOwner().equals(uuid)) continue;
            playerModules.add(module);
        }
        HashSet<Module> hashSet = playerModules;
        if (hashSet == null) {
            Moduler.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @Override
    public void registerModule(@NotNull Module module) {
        if (module == null) {
            Moduler.$$$reportNull$$$0(3);
        }
        this.modules.add(module);
        ModuleRegisterEvent event = new ModuleRegisterEvent(module);
        event.callEvent();
    }

    @Override
    public void createModule(@NotNull Player owner, @NotNull DevPlanet devPlanet, @NotNull Set<Location> locations) {
        CodeConfiguration configuration;
        if (owner == null) {
            Moduler.$$$reportNull$$$0(4);
        }
        if (devPlanet == null) {
            Moduler.$$$reportNull$$$0(5);
        }
        if (locations == null) {
            Moduler.$$$reportNull$$$0(6);
        }
        if (!new CodingBlockParser(devPlanet).parseExecutors(devPlanet, configuration = new CodeConfiguration(), new LinkedList<Location>(locations))) {
            owner.sendMessage(MessageUtils.getLocaleMessage("modules.error"));
            return;
        }
        configuration.set("owner", owner.getUniqueId().toString());
        configuration.set("name", MessageUtils.getPlayerLocaleMessage("modules.default-name", (OfflinePlayer)owner));
        configuration.set("description", MessageUtils.getPlayerLocaleMessage("modules.default-description", (OfflinePlayer)owner));
        configuration.set("icon", Material.CHEST.name());
        configuration.set("creation-time", System.currentTimeMillis());
        try {
            int id = Moduler.generateModuleId();
            configuration.save(new File(FileUtils.getModuleConfigFile(id).getPath()));
            Module module = new Module(id);
            ModuleCreationEvent event = new ModuleCreationEvent(module, owner);
            event.callEvent();
            if (event.isCancelled()) {
                return;
            }
            OpenCreative.getModuleManager().registerModule(module);
            owner.sendMessage(MessageUtils.getLocaleMessage("modules.created"));
            Sounds.DEV_MODULE_CREATED.play((Audience)owner);
        }
        catch (Exception e) {
            ErrorUtils.sendPlayerErrorMessage(owner, "Can't create a module", e);
            Sounds.PLAYER_FAIL.play((Audience)owner);
        }
    }

    @Override
    public void deleteModule(@NotNull Module module) {
        if (module == null) {
            Moduler.$$$reportNull$$$0(7);
        }
        ModuleDeletionEvent event = new ModuleDeletionEvent(module);
        event.callEvent();
        ModuleSettingsMenu.removeFromCurrentEditing(module);
        this.modules.remove(module);
        File file = FileUtils.getModuleConfigFile(module.getId());
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Error while deleting module " + module.getId(), error);
        }
    }

    public static int generateModuleId() {
        boolean exists;
        int newModuleId = OpenCreative.getPlugin().getConfig().getInt("last-module-id", 1);
        block0: do {
            ++newModuleId;
            exists = false;
            for (File file : FileUtils.getModulesFiles()) {
                if (!file.getName().equalsIgnoreCase("module" + newModuleId + ".yml")) continue;
                exists = true;
                continue block0;
            }
        } while (exists);
        OpenCreative.getPlugin().getConfig().set("last-module-id", (Object)newModuleId);
        OpenCreative.getPlugin().saveConfig();
        return newModuleId;
    }

    @Override
    public void init() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return "Module Manager";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uuid";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/managers/modules/Moduler";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/managers/modules/Moduler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlayerModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getModuleById";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPlayerModules";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerModule";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

