/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.BlockMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetPlayer;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class EnderChestMenu
extends AbstractMenu
implements WorldMenu,
BlockMenu {
    @NotNull
    private final Planet planet;
    @Nullable
    private final Location location;
    @Nullable
    private final BlockState blockState;

    public EnderChestMenu(@NotNull Planet planet, @Nullable Location location) {
        if (planet == null) {
            EnderChestMenu.$$$reportNull$$$0(0);
        }
        super(3, InventoryType.ENDER_CHEST.getDefaultTitle());
        this.planet = planet;
        this.location = location;
        this.blockState = location != null ? location.getBlock().getState() : null;
    }

    @Override
    public void fillItems(Player player) {
        PlanetPlayer planetPlayer = this.planet.getWorldPlayers().getPlanetPlayer(player);
        if (planetPlayer == null) {
            return;
        }
        int slot = 0;
        for (ItemStack item : planetPlayer.getSavedEnderChest()) {
            if (slot >= 27) {
                return;
            }
            this.setItem(slot, item);
            ++slot;
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            EnderChestMenu.$$$reportNull$$$0(1);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            EnderChestMenu.$$$reportNull$$$0(2);
        }
        if (this.location != null) {
            new BukkitRunnable(){

                public void run() {
                    for (Player player : EnderChestMenu.this.location.getWorld().getPlayers()) {
                        PlayerUtils.sendOpenedChestAnimation(player, EnderChestMenu.this.location.getBlock());
                    }
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), 10L);
        } else {
            event.getPlayer().playSound(Sound.sound((Key)Key.key((String)"block.ender_chest.open"), (Sound.Source)Sound.Source.BLOCK, (float)100.0f, (float)1.0f));
        }
    }

    @Override
    public void onClose(@NotNull InventoryCloseEvent event) {
        HumanEntity player2;
        if (event == null) {
            EnderChestMenu.$$$reportNull$$$0(3);
        }
        event.getPlayer().playSound(Sound.sound((Key)Key.key((String)"block.ender_chest.close"), (Sound.Source)Sound.Source.BLOCK, (float)100.0f, (float)1.0f));
        if (this.location != null) {
            for (HumanEntity player2 : this.location.getWorld().getPlayers()) {
                PlayerUtils.sendClosedChestAnimation((Player)player2, this.location.getBlock());
            }
        }
        if (!((player2 = event.getPlayer()) instanceof Player)) {
            return;
        }
        Player player3 = (Player)player2;
        PlanetPlayer planetPlayer = this.planet.getWorldPlayers().getPlanetPlayer(player3);
        if (planetPlayer == null) {
            return;
        }
        planetPlayer.saveEnderChest(this.getInventory().getContents());
        this.destroy();
    }

    @Override
    @NotNull
    public Planet getPlanet() {
        Planet planet = this.planet;
        if (planet == null) {
            EnderChestMenu.$$$reportNull$$$0(4);
        }
        return planet;
    }

    @Override
    @Nullable
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    @Nullable
    public Location getLocation() {
        return this.location;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/menus/EnderChestMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/EnderChestMenu";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onOpen";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onClose";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

