/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.BlockMenu;
import ua.mcchickenstudio.opencreative.menus.InventoryMenu;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class Menus
implements Listener {
    private static final List<InventoryMenu> activeMenus = new ArrayList<InventoryMenu>();
    private final BukkitRunnable runnable = new BukkitRunnable(this){

        public void run() {
            if (activeMenus.isEmpty()) {
                return;
            }
            for (InventoryMenu inventoryMenu : new ArrayList<InventoryMenu>(activeMenus)) {
                BlockMenu blockMenu;
                if (inventoryMenu instanceof BlockMenu && (blockMenu = (BlockMenu)((Object)inventoryMenu)).getLocation() != null && blockMenu.getBlockState() != null && !blockMenu.getLocation().getBlock().getState().equals((Object)blockMenu.getBlockState())) {
                    if (inventoryMenu.getInventory().getViewers().isEmpty()) {
                        Menus.removeMenu(inventoryMenu);
                    }
                    inventoryMenu.getInventory().close();
                }
                if (System.currentTimeMillis() - inventoryMenu.getCreationTime() <= 600000L) continue;
                if (inventoryMenu.getInventory().getViewers().isEmpty()) {
                    Menus.removeMenu(inventoryMenu);
                }
                inventoryMenu.getInventory().close();
            }
        }
    };

    public Menus() {
        this.runnable.runTaskTimer((Plugin)OpenCreative.getPlugin(), 20L, 20L);
    }

    public static void onBlockDestroy(Location location) {
        if (activeMenus.isEmpty()) {
            return;
        }
        for (InventoryMenu inventoryMenu : new ArrayList<InventoryMenu>(activeMenus)) {
            BlockMenu blockMenu;
            if (!(inventoryMenu instanceof BlockMenu) || !location.equals((Object)(blockMenu = (BlockMenu)((Object)inventoryMenu)).getLocation())) continue;
            if (inventoryMenu.getInventory().getViewers().isEmpty()) {
                Menus.removeMenu(inventoryMenu);
            }
            inventoryMenu.getInventory().close();
        }
    }

    public static void addMenu(InventoryMenu menu) {
        activeMenus.add(menu);
    }

    public static void removeMenu(InventoryMenu menu) {
        activeMenus.remove(menu);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        for (InventoryMenu menu : activeMenus) {
            block3: {
                if (event.getInventory().getHolder() != menu.getInventory().getHolder()) continue;
                try {
                    menu.onClick(event);
                }
                catch (Exception error) {
                    HumanEntity humanEntity = event.getWhoClicked();
                    if (!(humanEntity instanceof Player)) break block3;
                    Player player = (Player)humanEntity;
                    ErrorUtils.sendPlayerErrorMessage(player, "Can't handle click event in " + menu.getClass().getSimpleName(), error);
                }
            }
            return;
        }
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        for (InventoryMenu menu : activeMenus) {
            if (event.getInventory().getHolder() != menu.getInventory().getHolder()) continue;
            menu.onOpen(event);
            return;
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        for (InventoryMenu menu : activeMenus) {
            if (event.getInventory().getHolder() != menu.getInventory().getHolder()) continue;
            menu.onClose(event);
            return;
        }
    }
}

