/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.buttons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class RadioButton {
    private int currentChoice;
    private int maxChoicesAmount;
    private List<Runnable> choiceActions;
    private ItemStack buttonItem;
    private List<String> originalLore;
    private String turnedPath;
    private String itemLocalePath;
    static final Map<ItemStack, RadioButton> radioButtonList = new HashMap<ItemStack, RadioButton>();

    public RadioButton(Material material, String name, List<String> lore, int currentChoice, int maxChoicesAmount, List<Runnable> choicesActions, String itemLocalePath, String turnedPath) {
        this.setChoices(currentChoice, maxChoicesAmount, choicesActions);
        this.setItemButton(material, name, lore, itemLocalePath, turnedPath);
        radioButtonList.put(this.getButtonItem(), this);
    }

    private void setChoices(int currentChoice, int maxChoicesAmount, List<Runnable> choicesActions) {
        this.currentChoice = currentChoice;
        this.maxChoicesAmount = maxChoicesAmount;
        this.choiceActions = choicesActions;
    }

    private void setItemButton(Material material, String name, List<String> lore, String itemLocalePath, String chosenLocalePath) {
        this.originalLore = lore;
        this.itemLocalePath = itemLocalePath;
        this.turnedPath = chosenLocalePath;
        ItemStack buttonItem = new ItemStack(material, 1);
        ItemMeta buttonItemMeta = buttonItem.getItemMeta();
        buttonItemMeta.setDisplayName(name);
        buttonItem.setItemMeta(buttonItemMeta);
        this.buttonItem = buttonItem;
        this.updateItem();
    }

    public void updateItem() {
        ItemMeta buttonItemMeta = this.buttonItem.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        String turnedOn = MessageUtils.getLocaleMessage(this.turnedPath + ".turned-on");
        String turnedOff = MessageUtils.getLocaleMessage(this.turnedPath + ".turned-off");
        for (String loreLine : this.originalLore) {
            if (loreLine.matches("%[0-9]+%")) {
                int choiceNumber = Integer.parseInt(loreLine.replace("%", ""));
                String turned = choiceNumber == this.currentChoice ? turnedOn : turnedOff;
                loreLine = loreLine.replace("%" + choiceNumber + "%", turned + MessageUtils.getLocaleMessage(this.itemLocalePath + "." + choiceNumber, false));
            }
            lore.add(loreLine);
        }
        buttonItemMeta.setLore(lore);
        this.buttonItem.setItemMeta(buttonItemMeta);
    }

    public int getCurrentChoice() {
        return this.currentChoice;
    }

    public void onChoice() {
        int nextChoice;
        if (this.currentChoice == 0) {
            this.currentChoice = 1;
        }
        if ((nextChoice = this.currentChoice + 1) > this.maxChoicesAmount) {
            this.currentChoice = 1;
            nextChoice = 1;
        }
        if (nextChoice - 1 < this.choiceActions.size()) {
            Runnable actions = this.choiceActions.get(nextChoice - 1);
            actions.run();
        }
        this.currentChoice = nextChoice;
        radioButtonList.remove(this.buttonItem);
        this.updateItem();
        radioButtonList.put(this.buttonItem, this);
    }

    public ItemStack getButtonItem() {
        return this.buttonItem;
    }

    public static RadioButton getRadioButtonByItemStack(ItemStack itemStack) {
        return radioButtonList.get(itemStack);
    }
}

