/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.events.planet.PlanetSharingChangeEvent;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class WorldModerationMenu
extends AbstractMenu
implements WorldMenu {
    private final Planet planet;
    private final ItemStack CLEAR_NAME = ItemUtils.createItem(Material.NAME_TAG, 1, "menus.world-moderation.items.clear-name", "clear-name");
    private final ItemStack CLEAR_DESCRIPTION = ItemUtils.createItem(Material.BOOK, 1, "menus.world-moderation.items.clear-description", "clear-description");
    private final ItemStack CLEAR_ICON = ItemUtils.createItem(Material.DIAMOND, 1, "menus.world-moderation.items.clear-icon", "clear-icon");
    private final ItemStack CONNECT_SILENT = ItemUtils.createItem(Material.ENDER_EYE, 1, "menus.world-moderation.items.connect-silent", "connect-silent");
    private final ItemStack CONNECT_DEV_SILENT = ItemUtils.createItem(Material.ENDER_PEARL, 1, "menus.world-moderation.items.connect-dev-silent", "connect-dev-silent");
    private final ItemStack LOAD = ItemUtils.createItem(Material.CHERRY_CHEST_BOAT, 1, "menus.world-moderation.items.load", "load");
    private final ItemStack UNLOAD = ItemUtils.createItem(Material.CHEST_MINECART, 1, "menus.world-moderation.items.unload", "unload");
    private final ItemStack CLOSE_WORLD = ItemUtils.createItem(Material.BARRIER, 1, "menus.world-moderation.items.close-world", "close-world");

    public WorldModerationMenu(Planet planet) {
        super(4, MessageUtils.getLocaleMessage("menus.world-moderation.title", false));
        this.planet = planet;
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(this.DECORATION_PANE_ITEM, 28, 34);
        this.setItem(ItemUtils.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1), 29, 33);
        this.setItem(31, ItemUtils.setPersistentData(this.planet.getInformation().getIcon().clone(), ItemUtils.getItemTypeKey(), "connect"));
        this.setItem(10, player.hasPermission("opencreative.moderation.clear-name") ? this.CLEAR_NAME : this.NO_PERMS_ITEM);
        this.setItem(11, player.hasPermission("opencreative.moderation.clear-description") ? this.CLEAR_DESCRIPTION : this.NO_PERMS_ITEM);
        this.setItem(12, player.hasPermission("opencreative.moderation.clear-icon") ? this.CLEAR_ICON : this.NO_PERMS_ITEM);
        this.setItem(15, player.hasPermission("opencreative.moderation.connect-silent") ? (this.planet.isLoaded() ? this.CONNECT_SILENT : this.DECORATION_ITEM) : this.NO_PERMS_ITEM);
        this.setItem(16, player.hasPermission("opencreative.moderation.connect-dev-silent") ? (this.planet.isLoaded() ? this.CONNECT_DEV_SILENT : this.DECORATION_ITEM) : this.NO_PERMS_ITEM);
        this.setItem(27, this.planet.isLoaded() ? (player.hasPermission("opencreative.world.unload") ? this.UNLOAD : this.NO_PERMS_ITEM) : (player.hasPermission("opencreative.world.load") ? this.LOAD : this.NO_PERMS_ITEM));
        this.setItem(35, player.hasPermission("opencreative.moderation.close-world") ? (this.planet.getSharing() == Planet.Sharing.PUBLIC ? this.CLOSE_WORLD : this.DECORATION_ITEM) : this.NO_PERMS_ITEM);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldModerationMenu.$$$reportNull$$$0(0);
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            return;
        }
        if (item == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        switch (ItemUtils.getItemType(item)) {
            case "connect": {
                player.closeInventory();
                if (this.planet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
                    player.sendMessage(MessageUtils.getPlayerLocaleMessage("same-world", (OfflinePlayer)player));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                this.planet.connectPlayer(player);
                break;
            }
            case "connect-silent": {
                player.closeInventory();
                if (this.planet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
                    player.sendMessage(MessageUtils.getPlayerLocaleMessage("same-world", (OfflinePlayer)player));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                this.planet.connectPlayer(player, true);
                break;
            }
            case "connect-dev-silent": {
                player.closeInventory();
                this.planet.connectToDevPlanet(player, true);
                break;
            }
            case "clear-name": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(item.getType(), 20);
                this.planet.getInformation().setDisplayName(MessageUtils.getLocaleMessage("creating-world.default-world-name").replace("%player%", this.planet.getOwner()));
                Sounds.MENU_CLEAR_DATA.play((Audience)player);
                this.planet.getInformation().updateIcon();
                this.fillItems(player);
                break;
            }
            case "clear-description": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(item.getType(), 20);
                this.planet.getInformation().setDescription(MessageUtils.getLocaleMessage("creating-world.default-world-description").replace("%player%", this.planet.getOwner()));
                Sounds.MENU_CLEAR_DATA.play((Audience)player);
                this.planet.getInformation().updateIcon();
                this.fillItems(player);
                break;
            }
            case "clear-icon": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(item.getType(), 20);
                this.planet.getInformation().setIcon(new ItemStack(Material.DIAMOND));
                Sounds.MENU_CLEAR_DATA.play((Audience)player);
                this.planet.getInformation().updateIcon();
                this.fillItems(player);
                break;
            }
            case "close-world": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(item.getType(), 20);
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(this.planet, this.planet.getSharing(), Planet.Sharing.PRIVATE);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_SETTINGS_SHARING_PRIVATE.play((Audience)player);
                this.planet.setSharing(Planet.Sharing.PRIVATE);
                this.fillItems(player);
                break;
            }
            case "load": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.LOAD.getType(), 300);
                player.setCooldown(this.UNLOAD.getType(), 300);
                Sounds.WORLD_LOAD.play((Audience)player);
                OpenCreative.getPlugin().getLogger().info("Player " + player.getName() + " loads planet " + this.planet.getId());
                this.planet.getTerritory().load();
                Bukkit.getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> {
                    if (player.isOnline() && this.equals(player.getOpenInventory().getTopInventory().getHolder())) {
                        this.fillItems(player);
                    }
                }, 10L);
                break;
            }
            case "unload": {
                if (player.hasCooldown(item.getType())) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.LOAD.getType(), 300);
                player.setCooldown(this.UNLOAD.getType(), 300);
                Sounds.WORLD_UNLOAD.play((Audience)player);
                OpenCreative.getPlugin().getLogger().info("Player " + player.getName() + " unloads planet " + this.planet.getId());
                this.planet.getTerritory().unload();
                Bukkit.getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> {
                    if (player.isOnline() && this.equals(player.getOpenInventory().getTopInventory().getHolder())) {
                        this.fillItems(player);
                    }
                }, 10L);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldModerationMenu.$$$reportNull$$$0(1);
        }
        Sounds.MENU_OPEN_WORLD_MODERATION.play((Audience)event.getPlayer());
    }

    @Override
    public Planet getPlanet() {
        return this.planet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/WorldModerationMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

