/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.browsers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldAccessMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldGenerationMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.RecommendedWorldsMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class OwnWorldsBrowserMenu
extends ListBrowserMenu<Planet> {
    private final List<Planet> planets;
    private final ItemStack CREATE_WORLD = ItemUtils.createItem(Material.ENDER_EYE, 1, "menus.own-worlds.items.create-world");
    private final ItemStack WORLDS_LIMIT = ItemUtils.createItem(Material.RED_STAINED_GLASS, 1, "menus.own-worlds.items.limit");
    private final ItemStack RECOMMENDED = ItemUtils.createItem(Material.WIND_CHARGE, 1, "menus.own-worlds.items.recommended");

    public OwnWorldsBrowserMenu(Player player) {
        super(player, MessageUtils.getLocaleMessage("menus.own-worlds.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{45, 49}, new int[]{45, 46, 47, 51, 52, 53});
        this.planets = new ArrayList<Planet>(OpenCreative.getPlanetsManager().getPlanetsByOwner(player));
        Comparator sortByOnline = (planet1, planet2) -> Integer.compare(planet2.getOnline(), planet1.getOnline());
        this.planets.sort(sortByOnline);
    }

    @Override
    protected ItemStack getElementIcon(Planet planet) {
        ItemStack item = ItemUtils.clearItemMeta(planet.getInformation().getIcon().clone());
        ItemMeta meta = item.getItemMeta();
        meta.displayName(planet.getInformation().displayName());
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.own-worlds.items.world.lore")) {
            if (loreLine.contains("%planetDescription%")) {
                String[] newLines;
                for (String newLine : newLines = planet.getInformation().getDescription().split("\\\\n")) {
                    lore.add(loreLine.replace("%planetDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parsePlanetLines(planet, loreLine));
        }
        meta.setLore(lore);
        item.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DESTROYS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_PLACED_ON});
        item.setItemMeta(meta);
        ItemUtils.setPersistentData(item, ItemUtils.getItemIdKey(), String.valueOf(planet.getId()));
        return item;
    }

    @Override
    protected void fillOtherItems() {
        this.setItem(45, this.RECOMMENDED);
        int amount = OpenCreative.getPlanetsManager().getPlanetsByOwner(this.getPlayer()).size();
        int limit = OpenCreative.getSettings().getGroups().getGroup(this.getPlayer()).getWorldsLimit();
        if (OpenCreative.getSettings().isWorldGenerationUnavailable()) {
            this.setItem(ItemUtils.createItem(Material.RED_STAINED_GLASS_PANE, 1), 47, 51);
            this.setItem(49, this.DISABLED_ITEM);
            return;
        }
        if (amount >= limit) {
            this.setItem(ItemUtils.createItem(Material.RED_STAINED_GLASS_PANE, 1), 47, 51);
            ItemUtils.replacePlaceholderInLore(this.WORLDS_LIMIT, "%limit%", limit);
            ItemUtils.replacePlaceholderInLore(this.WORLDS_LIMIT, "%planets%", amount);
            this.setItem(49, this.WORLDS_LIMIT);
        } else {
            this.setItem(ItemUtils.createItem(Material.LIME_STAINED_GLASS_PANE, 1), 47, 51);
            this.setItem(49, this.CREATE_WORLD);
        }
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        if (ItemUtils.itemEquals(item, this.RECOMMENDED)) {
            new RecommendedWorldsMenu().open(this.getPlayer());
        } else if (ItemUtils.itemEquals(item, this.CREATE_WORLD) && this.isNotLimitReached()) {
            long now = System.currentTimeMillis();
            long minSeconds = OpenCreative.getSettings().getWorldCreationMinSeconds();
            long playedSeconds = (now - this.getPlayer().getFirstPlayed()) / 1000L;
            if (playedSeconds < minSeconds) {
                long unlockTime = now + (minSeconds - playedSeconds) * 1000L;
                Sounds.PLAYER_CANCEL.play((Audience)this.getPlayer());
                this.getPlayer().closeInventory();
                this.getPlayer().sendMessage(MessageUtils.getPlayerLocaleMessage("creating-world.not-enough-played", (OfflinePlayer)this.getPlayer()).replace("%time%", MessageUtils.convertTime(unlockTime)));
                return;
            }
            new WorldGenerationMenu(this.getPlayer()).open(this.getPlayer());
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        String worldID = ItemUtils.getPersistentData(currentItem, ItemUtils.getItemIdKey());
        if (worldID.isEmpty()) {
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetById(worldID);
        if (planet != null) {
            new WorldAccessMenu(planet).open(this.getPlayer());
        }
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.RECOMMENDED);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : this.RECOMMENDED);
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_ITEM);
        }
    }

    @Override
    public List<Planet> getElements() {
        return new ArrayList<Planet>(this.planets);
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, this.getCurrentPage() + 1, "menus.own-worlds.items.next-page"), "%page%", this.getCurrentPage() + 1);
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, Math.max(1, this.getCurrentPage() - 1), "menus.own-worlds.items.previous-page"), "%page%", this.getCurrentPage() - 1);
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.own-worlds.items.no-worlds");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            OwnWorldsBrowserMenu.$$$reportNull$$$0(0);
        }
        Sounds.MENU_OPEN_OWN_WORLDS_BROWSER.play((Audience)event.getPlayer());
    }

    private boolean isNotLimitReached() {
        int planetsLimit;
        int planetsAmount = OpenCreative.getPlanetsManager().getPlanetsByOwner(this.getPlayer()).size();
        return planetsAmount < (planetsLimit = OpenCreative.getSettings().getGroups().getGroup(this.getPlayer()).getWorldsLimit());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/world/browsers/OwnWorldsBrowserMenu", "onOpen"));
    }
}

