/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldEnvironmentColorMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public class WorldEnvironmentMenu
extends AbstractMenu {
    private final Player player;
    private final DevPlanet devPlanet;
    private final DevPlatform devPlatform;
    private final ItemStack back = ItemUtils.createItem(Material.ARROW, 1, "menus.developer.environment.items.back");
    private final ParameterButton debug;
    private final ItemStack variablesSize = ItemUtils.createItem(Material.MAGMA_CREAM, 1, "menus.developer.environment.items.variables-size");
    private final ItemStack variablesList = ItemUtils.createItem(Material.BOOKSHELF, 1, "menus.developer.environment.items.variables-list");
    private final ItemStack clearVariables = ItemUtils.createItem(Material.BRUSH, 1, "menus.developer.environment.items.clear-variables");
    private final ItemStack info;
    private final ItemStack createPlatform;
    private final ParameterButton containers;
    private final ParameterButton time;
    private final ItemStack floorMaterial;
    private final ItemStack eventMaterial;
    private final ItemStack actionMaterial;

    public WorldEnvironmentMenu(Player player, DevPlanet devPlanet) {
        super(6, MessageUtils.getLocaleMessage("menus.developer.environment.title"));
        boolean isEvening;
        this.player = player;
        this.devPlanet = devPlanet;
        this.devPlatform = WorldUtils.isDevPlanet(player.getWorld()) ? devPlanet.getPlatformInLocation(player.getLocation()) : null;
        this.debug = new ParameterButton((Object)(devPlanet.getPlanet().isDebug() ? "all" : "disabled"), List.of("disabled", "all"), "debug", "menus.developer.environment", "menus.developer.environment.items.debug", List.of(Material.PUFFERFISH_BUCKET, Material.PUFFERFISH));
        this.containers = new ParameterButton((Object)(devPlanet.getContainerMaterial() == Material.CHEST ? "chest" : "barrel"), List.of("chest", "barrel"), "containers", "menus.developer.environment", "menus.developer.environment.items.containers", List.of(Material.CHEST, Material.BARREL));
        this.info = this.createInfoItem();
        this.createPlatform = this.createPlatformsItem();
        long currentTime = devPlanet.getWorld() == null ? 0L : devPlanet.getWorld().getTime();
        boolean isMorning = currentTime >= 0L && currentTime < 6000L;
        boolean isNight = currentTime >= 15000L && currentTime <= 23000L;
        boolean bl = isEvening = currentTime >= 12500L && currentTime < 15000L;
        this.time = new ParameterButton((Object)(isMorning ? "morning" : (isNight ? "night" : (isEvening ? "evening" : "day"))), List.of("morning", "day", "evening", "night"), "time", "menus.developer.environment", "menus.developer.environment.items.time", Material.CLOCK);
        this.floorMaterial = ItemUtils.createItem(this.devPlatform != null ? this.devPlatform.getFloorMaterial() : DevPlanet.getDefaultFloorMaterial(), 1, "menus.developer.environment.items.floor-material");
        this.eventMaterial = ItemUtils.createItem(this.devPlatform != null ? this.devPlatform.getEventMaterial() : DevPlanet.getDefaultEventMaterial(), 1, "menus.developer.environment.items.event-material");
        this.actionMaterial = ItemUtils.createItem(this.devPlatform != null ? this.devPlatform.getActionMaterial() : DevPlanet.getDefaultActionMaterial(), 1, "menus.developer.environment.items.action-material");
    }

    private ItemStack createInfoItem() {
        ItemStack info = ItemUtils.createItem(Material.AMETHYST_CLUSTER, 1, "menus.developer.environment.items.info");
        ItemUtils.replacePlaceholderInLore(info, "%executors%", this.devPlanet.getPlanet().getTerritory().getScript().getExecutors().getExecutorsList().size());
        ItemUtils.replacePlaceholderInLore(info, "%scoreboards%", this.devPlanet.getPlanet().getTerritory().getScoreboards().size());
        ItemUtils.replacePlaceholderInLore(info, "%scoreboards-limit%", this.devPlanet.getPlanet().getLimits().getScoreboardsLimit());
        ItemUtils.replacePlaceholderInLore(info, "%bossbars%", this.devPlanet.getPlanet().getTerritory().getBossBars().size());
        ItemUtils.replacePlaceholderInLore(info, "%bossbars-limit%", this.devPlanet.getPlanet().getLimits().getBossBarsLimit());
        ItemUtils.replacePlaceholderInLore(info, "%variables%", this.devPlanet.getPlanet().getVariables().getTotalVariablesAmount());
        ItemUtils.replacePlaceholderInLore(info, "%variables-limit%", this.devPlanet.getPlanet().getLimits().getVariablesAmountLimit());
        ItemUtils.replacePlaceholderInLore(info, "%executor-calls-limit%", this.devPlanet.getPlanet().getLimits().getCodeOperationsLimit());
        ItemUtils.replacePlaceholderInLore(info, "%planetID%", this.devPlanet.getPlanet().getId());
        ItemUtils.replacePlaceholderInLore(info, "%version%", OpenCreative.getVersion());
        return info;
    }

    private ItemStack createPlatformsItem() {
        if (this.devPlanet.isLoaded()) {
            int limit;
            int amount = this.devPlanet.getPlatforms().size();
            ItemStack item = ItemUtils.createItem(Material.NETHER_STAR, 1, "menus.developer.environment.items." + (amount >= (limit = this.devPlanet.getPlanet().getLimits().getCodingPlatformsLimit()) ? "create-platform-limit" : "create-platform"), amount >= limit ? "" : "platform");
            ItemUtils.replacePlaceholderInLore(item, "%limit%", limit);
            ItemUtils.replacePlaceholderInLore(item, "%amount%", amount);
            return item;
        }
        return this.DECORATION_ITEM;
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.debug.getItem());
        this.setItem(12, this.variablesSize);
        this.setItem(14, this.variablesList);
        this.setItem(16, this.clearVariables);
        this.setItem(28, this.devPlanet.getWorld() != null ? this.containers.getItem() : this.DECORATION_ITEM);
        this.setItem(30, this.devPlanet.getWorld() != null ? this.time.getItem() : this.DECORATION_ITEM);
        this.setItem(32, this.devPlanet.getWorld() != null ? this.floorMaterial : this.DECORATION_ITEM);
        this.setItem(33, this.devPlanet.getWorld() != null ? this.eventMaterial : this.DECORATION_ITEM);
        this.setItem(34, this.devPlanet.getWorld() != null ? this.actionMaterial : this.DECORATION_ITEM);
        this.setItem(45, this.devPlanet.getPlanet().isOwner(player) ? this.back : this.DECORATION_PANE_ITEM);
        this.setItem(46, this.DECORATION_PANE_ITEM);
        this.setItem(47, ItemUtils.createItem(Material.MAGENTA_STAINED_GLASS_PANE, 1));
        this.setItem(49, this.info);
        this.setItem(51, ItemUtils.createItem(Material.MAGENTA_STAINED_GLASS_PANE, 1));
        this.setItem(52, this.DECORATION_PANE_ITEM);
        this.setItem(53, this.devPlanet.getWorld() != null ? this.createPlatform : this.DECORATION_ITEM);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldEnvironmentMenu.$$$reportNull$$$0(0);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null || currentItem.equals((Object)this.DECORATION_ITEM)) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.variablesList)) {
            this.player.performCommand("env vars list");
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.variablesSize)) {
            this.player.performCommand("env vars size");
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.clearVariables)) {
            this.player.performCommand("env vars clear");
            this.player.closeInventory();
        } else if (ItemUtils.getItemType(currentItem).equals("platform")) {
            this.player.performCommand("env platform");
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.time.getItem())) {
            if (this.devPlanet.getWorld() == null) {
                return;
            }
            this.time.next();
            Sounds.WORLD_SETTINGS_TIME_CHANGE.play((Audience)this.player);
            this.setItem(event.getRawSlot(), this.time.getItem());
            if ("night".equals(this.time.getCurrentValue().toString())) {
                this.devPlanet.getWorld().setTime(15000L);
            } else if ("evening".equals(this.time.getCurrentValue().toString())) {
                this.devPlanet.getWorld().setTime(12500L);
            } else if ("day".equals(this.time.getCurrentValue().toString())) {
                this.devPlanet.getWorld().setTime(6000L);
            } else {
                this.devPlanet.getWorld().setTime(0L);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.containers.getItem())) {
            if (this.devPlanet.getWorld() == null) {
                return;
            }
            this.player.performCommand("env barrel");
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.debug.getItem())) {
            this.player.performCommand("env debug " + (this.debug.getCurrentValue().toString().equals("all") ? "disable" : "enable"));
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.back)) {
            if (this.devPlanet.getPlanet().isOwner(this.player)) {
                new WorldSettingsMenu(this.devPlanet.getPlanet(), this.player).open(this.player);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.eventMaterial)) {
            new WorldEnvironmentColorMenu(this.player, this.devPlanet, this.devPlatform, "event").open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.actionMaterial)) {
            new WorldEnvironmentColorMenu(this.player, this.devPlanet, this.devPlatform, "action").open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.floorMaterial)) {
            new WorldEnvironmentColorMenu(this.player, this.devPlanet, this.devPlatform, "floor").open(this.player);
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldEnvironmentMenu.$$$reportNull$$$0(1);
        }
        Player player = (Player)event.getPlayer();
        Sounds.MENU_OPEN_ENVIRONMENT.play((Audience)player);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/settings/WorldEnvironmentMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

