/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.ChatColor;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.events.planet.PlanetSharingChangeEvent;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.menus.world.settings.EntitiesBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldEnvironmentMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsCategoryMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsFlagsMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsPlayersMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerConfirmation;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class WorldSettingsMenu
extends AbstractMenu {
    private final Planet planet;
    private final Player player;
    private final ItemStack playersControl = ItemUtils.createItem(Material.PLAYER_HEAD, 1, "menus.world-settings.items.planet-players");
    private final ItemStack parameters = ItemUtils.createItem(Material.COMPARATOR, 1, "menus.world-settings.items.planet-flags");
    private final ItemStack name = ItemUtils.createItem(Material.BIRCH_SIGN, 1, "menus.world-settings.items.change-name");
    private final ItemStack description = ItemUtils.createItem(Material.WRITABLE_BOOK, 1, "menus.world-settings.items.change-description");
    private final ItemStack category = ItemUtils.createItem(Material.NAME_TAG, 1, "menus.world-settings.items.change-category");
    private final ItemStack customID = ItemUtils.createItem(Material.LEAD, 1, "menus.world-settings.items.change-id");
    private final ItemStack buildMode = ItemUtils.createItem(Material.BRICKS, 1, "menus.world-settings.items.build-mode");
    private final ItemStack playMode = ItemUtils.createItem(Material.DIAMOND_BLOCK, 1, "menus.world-settings.items.play-mode");
    private final ItemStack devMode = ItemUtils.createItem(Material.REPEATING_COMMAND_BLOCK, 1, "menus.world-settings.items.dev-mode");
    private final ItemStack spawn = ItemUtils.createItem(Material.ENDER_PEARL, 1, "menus.world-settings.items.change-spawn");
    private final ParameterButton time;
    private final ItemStack controlMobs = ItemUtils.createItem(Material.BRUSH, 1, "menus.world-settings.items.entities-control");
    private final ItemStack environment = ItemUtils.createItem(Material.AMETHYST_CLUSTER, 1, "menus.world-settings.items.environment");
    private final ParameterButton autoSave;
    private final ParameterButton access;
    private ItemStack worldIcon;
    private final ItemStack advertise = ItemUtils.createItem(Material.BEACON, 1, "menus.world-settings.items.advertisement");

    public WorldSettingsMenu(Planet planet, Player player) {
        super(6, MessageUtils.getLocaleMessage("menus.world-settings.title", false));
        boolean isEvening;
        this.planet = planet;
        this.player = player;
        this.worldIcon = this.getPlanetIcon();
        this.access = new ParameterButton((Object)planet.getSharing().name().toLowerCase(), List.of("public", "private"), "access", "menus.world-settings", "menus.world-settings.items.change-sharing", List.of(Material.SPRUCE_DOOR, Material.IRON_DOOR));
        Boolean isTimeChanging = (Boolean)planet.getTerritory().getWorld().getGameRuleValue(GameRule.DO_DAYLIGHT_CYCLE);
        long currentTime = planet.getTerritory().getWorld().getTime();
        boolean isNight = currentTime >= 15000L && currentTime <= 23000L;
        boolean bl = isEvening = currentTime >= 12500L && currentTime < 15000L;
        int timeValue = isTimeChanging != null && isTimeChanging != false ? 4 : (isNight ? 3 : (isEvening ? 2 : 1));
        this.time = new ParameterButton((Object)timeValue, List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), "time", "menus.world-settings", "menus.world-settings.items.time", Material.CLOCK);
        this.autoSave = new ParameterButton((Object)planet.getTerritory().getWorld().isAutoSave(), List.of(Boolean.valueOf(true), Boolean.valueOf(false)), "autosave", "menus.world-settings", "menus.world-settings.items.autosave", List.of(Material.CHEST_MINECART, Material.TNT_MINECART));
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.playersControl);
        this.setItem(11, this.parameters);
        this.setItem(19, this.name);
        this.setItem(20, this.description);
        this.setItem(28, this.category);
        this.setItem(29, this.customID);
        this.setItem(15, this.spawn);
        this.setItem(16, this.time.getItem());
        this.setItem(24, this.controlMobs);
        this.setItem(25, this.environment);
        this.setItem(33, this.autoSave.getItem());
        this.setItem(13, this.buildMode);
        this.setItem(22, this.playMode);
        this.setItem(31, this.devMode);
        this.setItem(45, this.DECORATION_PANE_ITEM);
        this.setItem(46, ItemUtils.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1));
        this.setItem(47, this.access.getItem());
        this.setItem(49, this.worldIcon);
        this.setItem(51, this.advertise);
        this.setItem(52, ItemUtils.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1));
        this.setItem(53, this.DECORATION_PANE_ITEM);
    }

    public ItemStack getPlanetIcon() {
        ItemStack item = ItemUtils.clearItemMeta(this.planet.getInformation().getIcon().clone());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings.items.world.name").replace("%planetName%", this.planet.getInformation().getDisplayName()));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.world-settings.items.world.lore")) {
            if (loreLine.contains("%planetDescription%")) {
                String[] newLines;
                for (String newLine : newLines = this.planet.getInformation().getDescription().split("\\\\n")) {
                    lore.add(loreLine.replace("%planetDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parsePlanetLines(this.planet, loreLine));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUtils.clearItemFlags(item);
        return item;
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldSettingsMenu.$$$reportNull$$$0(0);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.name)) {
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-name.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-name.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
            this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-name.usage").replace("%player%", this.player.getName()));
            this.player.closeInventory();
            if (!ChatListener.confirmation.containsKey(this.player)) {
                ChatListener.confirmation.put(this.player, PlayerConfirmation.WORLD_NAME_CHANGE);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.description)) {
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-description.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-description.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
            this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-description.usage"));
            this.player.closeInventory();
            if (!ChatListener.confirmation.containsKey(this.player)) {
                ChatListener.confirmation.put(this.player, PlayerConfirmation.WORLD_DESCRIPTION_CHANGE);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.customID)) {
            this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-id.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-id.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
            this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-id.usage").replace("%player%", this.player.getName()));
            this.player.closeInventory();
            if (!ChatListener.confirmation.containsKey(this.player)) {
                ChatListener.confirmation.put(this.player, PlayerConfirmation.WORLD_CUSTOM_ID_CHANGE);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.spawn)) {
            if (PlayerUtils.isEntityInDevPlanet((Entity)this.player)) {
                Sounds.PLAYER_FAIL.play((Audience)this.player);
                return;
            }
            this.player.closeInventory();
            if (event.getClick().isLeftClick()) {
                this.player.getWorld().setSpawnLocation(this.player.getLocation());
                this.player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-spawn.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("settings.world-spawn.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(130L))));
                Sounds.WORLD_SETTINGS_SPAWN_SET.play((Audience)this.player);
            } else {
                this.player.teleport(this.player.getWorld().getSpawnLocation());
                Sounds.WORLD_SETTINGS_SPAWN_TELEPORT.play((Audience)this.player);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.category)) {
            new WorldSettingsCategoryMenu(this.planet.getInformation().getCategory()).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.playersControl)) {
            WorldSettingsPlayersMenu.openInventory(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.parameters)) {
            new WorldSettingsFlagsMenu().open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.environment)) {
            new WorldEnvironmentMenu(this.player, this.planet.getDevPlanet()).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.advertise)) {
            this.player.performCommand("ad");
            this.player.closeInventory();
        } else if (ItemUtils.itemEquals(currentItem, this.controlMobs)) {
            new EntitiesBrowserMenu(this.player, this.planet).open(this.player);
        } else if (ItemUtils.itemEquals(currentItem, this.buildMode)) {
            this.player.performCommand("build");
        } else if (ItemUtils.itemEquals(currentItem, this.playMode)) {
            this.player.performCommand("play");
        } else if (ItemUtils.itemEquals(currentItem, this.devMode)) {
            this.player.performCommand("dev");
        } else if (ItemUtils.itemEquals(currentItem, this.access.getItem())) {
            this.access.next();
            this.setItem(event.getRawSlot(), this.access.getItem());
            if ("public".equals(this.access.getCurrentValue().toString())) {
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(this.planet, this.planet.getSharing(), Planet.Sharing.PUBLIC, this.player);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    return;
                }
                this.planet.setSharing(Planet.Sharing.PUBLIC);
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-sharing.enabled"));
                Sounds.WORLD_SETTINGS_SHARING_PUBLIC.play((Audience)this.player);
                this.planet.getInformation().updateIcon();
            } else {
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(this.planet, this.planet.getSharing(), Planet.Sharing.PRIVATE, this.player);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    return;
                }
                this.planet.setSharing(Planet.Sharing.PRIVATE);
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-sharing.disabled"));
                Sounds.WORLD_SETTINGS_SHARING_PRIVATE.play((Audience)this.player);
                this.planet.getInformation().updateIcon();
            }
            this.worldIcon = this.getPlanetIcon();
            this.setItem(49, this.getPlanetIcon());
        } else if (ItemUtils.itemEquals(currentItem, this.time.getItem())) {
            this.time.next();
            Sounds.WORLD_SETTINGS_TIME_CHANGE.play((Audience)this.player);
            this.setItem(event.getRawSlot(), this.time.getItem());
            if (this.time.getCurrentValue().equals(1)) {
                this.planet.getTerritory().getWorld().setTime(1000L);
                this.planet.getTerritory().getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                this.planet.setFlagValue(PlanetFlags.PlanetFlag.DAY_CYCLE, (byte)1);
            } else if (this.time.getCurrentValue().equals(2)) {
                this.planet.getTerritory().getWorld().setTime(12500L);
                this.planet.getTerritory().getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                this.planet.setFlagValue(PlanetFlags.PlanetFlag.DAY_CYCLE, (byte)2);
            } else if (this.time.getCurrentValue().equals(3)) {
                this.planet.getTerritory().getWorld().setTime(15000L);
                this.planet.getTerritory().getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
                this.planet.setFlagValue(PlanetFlags.PlanetFlag.DAY_CYCLE, (byte)3);
            } else {
                this.planet.getTerritory().getWorld().setTime(1000L);
                this.planet.getTerritory().getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)true);
                this.planet.setFlagValue(PlanetFlags.PlanetFlag.DAY_CYCLE, (byte)4);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.autoSave.getItem())) {
            this.autoSave.next();
            this.setItem(event.getRawSlot(), this.autoSave.getItem());
            if (this.autoSave.getCurrentValue().equals(true)) {
                this.planet.getTerritory().setAutoSave(true);
                Sounds.WORLD_SETTINGS_AUTOSAVE_ON.play((Audience)this.player);
            } else if (this.autoSave.getCurrentValue().equals(false)) {
                this.planet.getTerritory().setAutoSave(false);
                Sounds.WORLD_SETTINGS_AUTOSAVE_OFF.play((Audience)this.player);
            }
        } else if (ItemUtils.itemEquals(currentItem, this.worldIcon)) {
            if (event.getCursor().isEmpty()) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-icon.error"));
                Sounds.PLAYER_FAIL.play((Audience)this.player);
            } else {
                this.planet.getInformation().setIcon(event.getCursor());
                this.player.sendMessage(MessageUtils.getLocaleMessage("settings.world-icon.changed"));
                this.worldIcon = this.getPlanetIcon();
                this.setItem(49, this.getPlanetIcon());
                event.setCursor(null);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldSettingsMenu.$$$reportNull$$$0(1);
        }
        if (!this.planet.isOwner(event.getPlayer().getName())) {
            event.setCancelled(true);
            return;
        }
        Sounds.MENU_OPEN_WORLD_SETTINGS.play((Audience)this.player);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/settings/WorldSettingsMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

