/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.menus.layouts.Layout;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.DevPlanetChunkGenerator;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformers;
import ua.mcchickenstudio.opencreative.utils.world.platforms.HasVisibleBorder;

public class DevPlanet {
    private final Planet planet;
    private String platformerID = "";
    private Material signMaterial = Material.BIRCH_WALL_SIGN;
    private Material containerMaterial = Material.CHEST;
    private boolean dropItems = true;
    private boolean saveLocation = true;
    private boolean nightVision = true;
    private boolean isCodeChanged = false;
    private final Map<Player, Location> lastLocations = new HashMap<Player, Location>();
    private final Map<Location, Layout> openedBlocksMenus = new HashMap<Location, Layout>();
    private final Map<Player, Set<Location>> selectedExecutors = new HashMap<Player, Set<Location>>();
    private static final Material DEFAULT_EVENT_MATERIAL = Material.BLUE_STAINED_GLASS;
    private static final Material DEFAULT_ACTION_MATERIAL = Material.GRAY_STAINED_GLASS;
    private static final Material DEFAULT_FLOOR_MATERIAL = Material.WHITE_STAINED_GLASS;

    public DevPlanet(Planet planet) {
        this.planet = planet;
        this.loadInformation();
    }

    private void loadInformation() {
        FileConfiguration config = FileUtils.getPlanetConfig(this.planet);
        try {
            this.containerMaterial = Material.getMaterial((String)config.getString("dev.container", "CHEST"));
            if (this.containerMaterial == null || !this.containerMaterial.isBlock()) {
                this.containerMaterial = Material.CHEST;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.signMaterial = Material.getMaterial((String)config.getString("dev.sign", "BIRCH_WALL_SIGN"));
            if (this.signMaterial == null || !this.signMaterial.isBlock()) {
                this.signMaterial = Material.BIRCH_WALL_SIGN;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dropItems = config.getBoolean("dev.drops", true);
        this.saveLocation = config.getBoolean("dev.save-location", true);
        this.nightVision = config.getBoolean("dev.night-vision", true);
        this.platformerID = config.getString("dev.platformer", "");
    }

    public void loadDevPlanetWorld() {
        long startTime = System.currentTimeMillis();
        boolean existed = this.exists();
        World world = Bukkit.createWorld((WorldCreator)new WorldCreator(this.getWorldName()).type(WorldType.FLAT).generator((ChunkGenerator)new DevPlanetChunkGenerator()));
        if (world == null) {
            ErrorUtils.sendCriticalErrorMessage("Failed to load Dev planet world " + this.planet.getId());
            return;
        }
        if (existed) {
            if (world.getBlockAt(4, 0, 4).isEmpty()) {
                this.createPlatform(1, 1);
            }
        } else {
            this.createPlatform(1, 1);
            world.setTime(12500L);
        }
        this.setupWorld();
        long endTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Dev planet world " + this.planet.getId() + " loaded in " + (endTime - startTime) + " ms");
    }

    public void unload() {
        if (!this.isLoaded()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        for (Player player : this.getWorld().getPlayers()) {
            PlayerUtils.teleportToLobby(player);
        }
        Bukkit.unloadWorld((String)this.getWorldName(), (boolean)true);
        long endTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Dev planet world " + this.planet.getId() + " unloaded in " + (endTime - startTime) + " ms");
    }

    public void setupWorld() {
        this.getWorld().setSpawnLocation(2, 1, 2);
        this.getWorld().setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
        this.getWorld().setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
        this.getWorld().setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        this.getWorld().setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
        this.getWorld().setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
        this.getWorld().setGameRule(GameRule.MOB_GRIEFING, (Object)false);
        this.getWorld().setGameRule(GameRule.DO_PATROL_SPAWNING, (Object)false);
        this.getWorld().setGameRule(GameRule.DO_FIRE_TICK, (Object)false);
        this.getDevPlatformer().setWorldBorder(this);
        this.isCodeChanged = false;
    }

    public boolean exists() {
        boolean exists = false;
        for (File folder : FileUtils.getWorldsFolders()) {
            if (!folder.getName().equalsIgnoreCase("planet" + this.planet.getId() + "dev")) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public void translateCodingBlocks(Player player) {
        if (!this.isLoaded()) {
            return;
        }
        for (int z = 4; z < 96; z = (int)((byte)(z + 4))) {
            Block executorBlock = this.getWorld().getBlockAt(4, 1, z);
            PlayerUtils.translateBlockSign(executorBlock.getRelative(BlockFace.SOUTH), player);
            for (int x = 6; x < 96; x = (int)((byte)(x + 2))) {
                Block actionBlock = this.getWorld().getBlockAt(x, 1, z);
                PlayerUtils.translateBlockSign(actionBlock.getRelative(BlockFace.SOUTH), player);
            }
        }
    }

    public Set<Material> getAllCodingBlocksForPlacing() {
        HashSet<Material> allBlocks = new HashSet<Material>();
        allBlocks.addAll(this.getEventsBlocks());
        allBlocks.addAll(this.getActionsBlocks());
        return allBlocks;
    }

    public Set<Material> getEventsBlocks() {
        return new HashSet<Material>(Arrays.stream(ExecutorCategory.values()).map(ExecutorCategory::getBlock).toList());
    }

    public Set<Material> getActionsBlocks() {
        return new HashSet<Material>(Arrays.stream(ActionCategory.values()).map(ActionCategory::getBlock).toList());
    }

    public boolean createPlatform(int platformX, int platformZ) {
        if (platformX >= 30 || platformZ >= 30 || platformX <= 0 || platformZ <= 0) {
            return false;
        }
        return this.getDevPlatformer().buildPlatform(new DevPlatform(this.getWorld(), this.getDevPlatformer(), platformX, platformZ), DEFAULT_FLOOR_MATERIAL, DEFAULT_EVENT_MATERIAL, DEFAULT_ACTION_MATERIAL);
    }

    public boolean claimPlatform(DevPlatform platform, Player player) {
        if (this.getDevPlatformer().claimPlatform(this, platform)) {
            player.setAllowFlight(true);
            player.setFlying(true);
            player.teleport(platform.getSpawnLocation());
            player.sendMessage(MessageUtils.getLocaleMessage("environment.platform.claimed"));
            Sounds.DEV_PLATFORM_CLAIM.play((Audience)player);
            return true;
        }
        return false;
    }

    public Set<Material> getIndestructibleBlocks() {
        HashSet<Material> indestructibleBlocks = new HashSet<Material>();
        indestructibleBlocks.add(DEFAULT_ACTION_MATERIAL);
        indestructibleBlocks.add(DEFAULT_EVENT_MATERIAL);
        indestructibleBlocks.add(DEFAULT_FLOOR_MATERIAL);
        indestructibleBlocks.add(Material.DIAMOND_ORE);
        indestructibleBlocks.add(Material.GOLD_ORE);
        indestructibleBlocks.add(Material.REDSTONE_ORE);
        indestructibleBlocks.addAll(Arrays.stream(ExecutorCategory.values()).map(ExecutorCategory::getAdditionalBlock).toList());
        indestructibleBlocks.addAll(Arrays.stream(ActionCategory.values()).map(ActionCategory::getAdditionalBlock).toList());
        indestructibleBlocks.remove(Material.PISTON);
        return indestructibleBlocks;
    }

    public Set<Material> getAllowedBlocks() {
        HashSet<Material> allowedBlocks = new HashSet<Material>();
        allowedBlocks.add(Material.LANTERN);
        allowedBlocks.add(Material.JACK_O_LANTERN);
        allowedBlocks.add(Material.SOUL_LANTERN);
        allowedBlocks.add(Material.TORCH);
        allowedBlocks.add(Material.SOUL_TORCH);
        allowedBlocks.add(Material.BARREL);
        allowedBlocks.add(Material.OAK_SIGN);
        allowedBlocks.add(Material.SPRUCE_SIGN);
        allowedBlocks.add(Material.ACACIA_SIGN);
        allowedBlocks.add(Material.BAMBOO_SIGN);
        allowedBlocks.add(Material.JUNGLE_SIGN);
        allowedBlocks.add(Material.CHERRY_SIGN);
        allowedBlocks.add(Material.WARPED_SIGN);
        allowedBlocks.add(Material.CRIMSON_SIGN);
        allowedBlocks.add(Material.MANGROVE_SIGN);
        allowedBlocks.add(Material.DARK_OAK_SIGN);
        allowedBlocks.add(Material.BIRCH_SIGN);
        allowedBlocks.add(Material.CRAFTING_TABLE);
        allowedBlocks.add(Material.JUKEBOX);
        allowedBlocks.add(Material.STONECUTTER);
        allowedBlocks.add(Material.CARTOGRAPHY_TABLE);
        allowedBlocks.add(Material.SMITHING_TABLE);
        allowedBlocks.add(Material.LOOM);
        allowedBlocks.add(Material.GRINDSTONE);
        allowedBlocks.add(Material.CHEST);
        allowedBlocks.add(Material.ANVIL);
        allowedBlocks.add(Material.CHIPPED_ANVIL);
        allowedBlocks.add(Material.DAMAGED_ANVIL);
        allowedBlocks.add(Material.ENDER_CHEST);
        allowedBlocks.add(Material.SHULKER_BOX);
        allowedBlocks.add(Material.WHITE_SHULKER_BOX);
        allowedBlocks.add(Material.BLACK_SHULKER_BOX);
        allowedBlocks.add(Material.BLUE_SHULKER_BOX);
        allowedBlocks.add(Material.BROWN_SHULKER_BOX);
        allowedBlocks.add(Material.CYAN_SHULKER_BOX);
        allowedBlocks.add(Material.MAGENTA_SHULKER_BOX);
        allowedBlocks.add(Material.GRAY_SHULKER_BOX);
        allowedBlocks.add(Material.GREEN_SHULKER_BOX);
        allowedBlocks.add(Material.LIME_SHULKER_BOX);
        allowedBlocks.add(Material.RED_SHULKER_BOX);
        allowedBlocks.add(Material.ORANGE_SHULKER_BOX);
        allowedBlocks.add(Material.PURPLE_SHULKER_BOX);
        allowedBlocks.add(Material.YELLOW_SHULKER_BOX);
        allowedBlocks.add(Material.LIGHT_BLUE_SHULKER_BOX);
        allowedBlocks.add(Material.LIGHT_GRAY_SHULKER_BOX);
        allowedBlocks.add(Material.PINK_SHULKER_BOX);
        return allowedBlocks;
    }

    public List<Location> getPlacedExecutors(ExecutorCategory category) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (DevPlatform platform : this.getPlatforms()) {
            locations.addAll(platform.getPlacedExecutors(category));
        }
        return locations;
    }

    public List<Location> getPlacedFunctions() {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Location location : this.getPlacedExecutors(ExecutorCategory.FUNCTION)) {
            Block block = location.getBlock();
            String line = BlockUtils.getSignLine(block.getRelative(BlockFace.SOUTH).getLocation(), 3);
            if (line == null || line.isEmpty()) continue;
            locations.add(block.getLocation());
        }
        return locations;
    }

    public List<Location> getPlacedMethods() {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Location location : this.getPlacedExecutors(ExecutorCategory.METHOD)) {
            Block block = location.getBlock();
            String line = BlockUtils.getSignLine(block.getRelative(BlockFace.SOUTH).getLocation(), 3);
            if (line == null || line.isEmpty()) continue;
            locations.add(block.getLocation());
        }
        return locations;
    }

    public void updateContainers() {
        if (!this.isLoaded()) {
            return;
        }
        for (DevPlatform platform : this.getPlatforms()) {
            platform.setContainerMaterial(this.containerMaterial);
        }
    }

    public void updateSigns() {
        if (!this.isLoaded()) {
            return;
        }
        for (DevPlatform platform : this.getPlatforms()) {
            platform.setSignMaterial(this.signMaterial);
        }
    }

    public boolean isLoaded() {
        return Bukkit.getWorld((String)this.getWorldName()) != null;
    }

    public Layout getOpenedMenu(Location location) {
        return this.openedBlocksMenus.get(location);
    }

    public void registerOpenedMenu(Location location, Layout menu) {
        this.openedBlocksMenus.put(location, menu);
    }

    public void unregisterOpenedMenu(Location location) {
        this.openedBlocksMenus.remove(location);
    }

    public Material getContainerMaterial() {
        return this.containerMaterial;
    }

    public Material getSignMaterial() {
        return this.signMaterial;
    }

    public boolean isNightVision() {
        return this.nightVision;
    }

    public boolean isSaveLocation() {
        return this.saveLocation;
    }

    public boolean isDropItems() {
        return this.dropItems;
    }

    public void setPlatformerID(String platformer) {
        this.platformerID = platformer;
        FileUtils.setPlanetConfigParameter(this.planet, "dev.platformer", this.platformerID);
    }

    public void setNightVision(boolean nightVision) {
        this.nightVision = nightVision;
        FileUtils.setPlanetConfigParameter(this.planet, "dev.night-vision", nightVision);
    }

    public void setSaveLocation(boolean saveLocation) {
        this.saveLocation = saveLocation;
        FileUtils.setPlanetConfigParameter(this.planet, "dev.save-location", saveLocation);
    }

    public void setDropItems(boolean dropItems) {
        this.dropItems = dropItems;
        FileUtils.setPlanetConfigParameter(this.planet, "dev.drops", dropItems);
    }

    public boolean setContainerMaterial(Material containerMaterial) {
        if (containerMaterial == Material.BARREL || containerMaterial == Material.CHEST || containerMaterial.name().endsWith("SHULKER_BOX")) {
            this.containerMaterial = containerMaterial;
            FileUtils.setPlanetConfigParameter(this.planet, "dev.container", containerMaterial.name());
            return true;
        }
        return false;
    }

    public boolean setSignMaterial(Material signMaterial) {
        if (signMaterial == Material.OAK_WALL_SIGN || signMaterial == Material.ACACIA_WALL_SIGN || signMaterial == Material.BAMBOO_WALL_SIGN || signMaterial == Material.CHERRY_WALL_SIGN || signMaterial == Material.BIRCH_WALL_SIGN || signMaterial == Material.JUNGLE_WALL_SIGN) {
            this.signMaterial = signMaterial;
            FileUtils.setPlanetConfigParameter(this.planet, "dev.sign", signMaterial.name());
            return true;
        }
        return false;
    }

    public String getWorldName() {
        return this.planet.getWorldName() + "dev";
    }

    public List<DevPlatform> getPlatforms() {
        return this.getDevPlatformer().getPlatforms(this);
    }

    public DevPlatform getPlatformInLocation(Location location) {
        return this.getDevPlatformer().getPlatformInLocation(this, location);
    }

    public void displayWorldBorders() {
        if (!this.isLoaded()) {
            return;
        }
        if (this.getDevPlatformer() instanceof HasVisibleBorder) {
            return;
        }
        for (Player player : this.getWorld().getPlayers()) {
            WorldBorder border = Bukkit.createWorldBorder();
            border.setCenter(this.getWorld().getWorldBorder().getCenter());
            border.setSize(this.getWorld().getWorldBorder().getSize() * 5.0);
            player.setWorldBorder(border);
        }
    }

    @NotNull
    public DevPlatformer getDevPlatformer() {
        if (this.platformerID == null || this.platformerID.isEmpty()) {
            DevPlatformer devPlatformer = OpenCreative.getDevPlatformer();
            if (devPlatformer == null) {
                DevPlanet.$$$reportNull$$$0(0);
            }
            return devPlatformer;
        }
        DevPlatformer platformer = DevPlatformers.getInstance().getById(this.platformerID);
        if (platformer == null) {
            DevPlatformer devPlatformer = OpenCreative.getDevPlatformer();
            if (devPlatformer == null) {
                DevPlanet.$$$reportNull$$$0(1);
            }
            return devPlatformer;
        }
        DevPlatformer devPlatformer = platformer;
        if (devPlatformer == null) {
            DevPlanet.$$$reportNull$$$0(2);
        }
        return devPlatformer;
    }

    public static Material getDefaultActionMaterial() {
        return DEFAULT_ACTION_MATERIAL;
    }

    public static Material getDefaultEventMaterial() {
        return DEFAULT_EVENT_MATERIAL;
    }

    public static Material getDefaultFloorMaterial() {
        return DEFAULT_FLOOR_MATERIAL;
    }

    public Map<Player, Location> getLastLocations() {
        return this.lastLocations;
    }

    @NotNull
    public Set<Location> getMarkedExecutors(@NotNull Player player) {
        if (player == null) {
            DevPlanet.$$$reportNull$$$0(3);
        }
        Set set = this.selectedExecutors.getOrDefault(player, new LinkedHashSet());
        if (set == null) {
            DevPlanet.$$$reportNull$$$0(4);
        }
        return set;
    }

    public void markExecutorAsSelected(@NotNull Player player, @NotNull Location location) {
        if (player == null) {
            DevPlanet.$$$reportNull$$$0(5);
        }
        if (location == null) {
            DevPlanet.$$$reportNull$$$0(6);
        }
        Set locations = this.selectedExecutors.getOrDefault(player, new LinkedHashSet());
        locations.add(location);
        this.selectedExecutors.put(player, locations);
    }

    public void unselectMarkedExecutor(@NotNull Player player, @NotNull Location location) {
        if (player == null) {
            DevPlanet.$$$reportNull$$$0(7);
        }
        if (location == null) {
            DevPlanet.$$$reportNull$$$0(8);
        }
        Set locations = this.selectedExecutors.getOrDefault(player, new LinkedHashSet());
        locations.remove(location);
        if (locations.isEmpty()) {
            this.selectedExecutors.remove(player);
        } else {
            this.selectedExecutors.put(player, locations);
        }
    }

    public void clearMarkedExecutors(@NotNull Location location) {
        if (location == null) {
            DevPlanet.$$$reportNull$$$0(9);
        }
        for (Player player : new HashSet<Player>(this.selectedExecutors.keySet())) {
            Set<Location> locations = this.selectedExecutors.get(player);
            if (locations == null || locations.isEmpty()) continue;
            locations.remove(location);
            this.selectedExecutors.put(player, locations);
        }
    }

    public boolean isCodeChanged() {
        return this.isCodeChanged;
    }

    public void setCodeChanged(boolean codeChanged) {
        this.isCodeChanged = codeChanged;
    }

    public void clearMarkedExecutors(@NotNull Player player) {
        if (player == null) {
            DevPlanet.$$$reportNull$$$0(10);
        }
        this.selectedExecutors.remove(player);
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.getWorldName());
    }

    public Planet getPlanet() {
        return this.planet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/planets/DevPlanet";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDevPlatformer";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/planets/DevPlanet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMarkedExecutors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMarkedExecutors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markExecutorAsSelected";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unselectMarkedExecutor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clearMarkedExecutors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

