/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.block.sign.Side;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.cache.ChunkCache;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;

public class DevPlatform {
    private final int x;
    private final int z;
    private final World world;
    private final DevPlatformer platformer;

    public DevPlatform(DevPlanet devPlanet, int x, int z) {
        this.x = x;
        this.z = z;
        this.world = devPlanet.getWorld();
        this.platformer = devPlanet.getDevPlatformer();
    }

    public DevPlatform(World world, DevPlatformer platformer, int x, int z) {
        this.x = x;
        this.z = z;
        this.world = world;
        this.platformer = platformer;
    }

    public DevPlatform(World world, int x, int z) {
        this.x = x;
        this.z = z;
        this.world = world;
        this.platformer = OpenCreative.getDevPlatformer();
    }

    public boolean exists() {
        Location begin = this.platformer.getPlatformBeginLocation(this).add(4.0, 0.0, 4.0);
        if (!ChunkCache.isChunkGenerated(this.world, begin.getBlockX() >> 4, begin.getBlockZ() >> 4)) {
            return false;
        }
        return begin.getBlock().isSolid();
    }

    public boolean isEmptyColumn(int column) {
        if (column < 1 || column > 24) {
            throw new IllegalArgumentException("Developer platform column must be in range from 1 to 24.");
        }
        Location begin = this.platformer.getPlatformBeginLocation(this);
        Location end = this.platformer.getPlatformEndLocation(this);
        int z = begin.getBlockZ() + column * 4;
        for (int x = begin.getBlockX() + 4; x <= end.getBlockX() - 3; ++x) {
            Block block = this.world.getBlockAt(x, begin.getBlockY() + 1, z);
            if (block.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<Location> getFreeColumns() {
        ArrayList<Location> columns = new ArrayList<Location>();
        for (int column = 1; column <= 24; ++column) {
            if (!this.isEmptyColumn(column)) continue;
            columns.add(this.platformer.getPlatformBeginLocation(this).clone().add(4.0, 0.0, (double)(column * 4)));
        }
        return columns;
    }

    public Material getFloorMaterial() {
        return this.world.getBlockAt(this.platformer.getPlatformBeginLocation(this)).getType();
    }

    public Material getEventMaterial() {
        return this.world.getBlockAt(this.platformer.getPlatformBeginLocation(this).clone().add(4.0, 0.0, 4.0)).getType();
    }

    public Material getActionMaterial() {
        return this.world.getBlockAt(this.platformer.getPlatformBeginLocation(this).clone().add(6.0, 0.0, 4.0)).getType();
    }

    public boolean cantBePlatformMaterial(Material material) {
        if (!material.isBlock()) {
            return true;
        }
        return material != Material.BARRIER && !material.name().endsWith("GLASS");
    }

    public boolean setMaterials(Material floor, Material event, Material action) {
        if (this.cantBePlatformMaterial(floor) || this.cantBePlatformMaterial(event) || this.cantBePlatformMaterial(action)) {
            return false;
        }
        if (floor == event || floor == action || event == action) {
            return false;
        }
        return this.platformer.buildPlatform(this, floor, event, action);
    }

    public boolean setFloorMaterial(Material floor) {
        if (this.cantBePlatformMaterial(floor)) {
            return false;
        }
        if (floor == this.getEventMaterial()) {
            return false;
        }
        if (floor == this.getActionMaterial()) {
            return false;
        }
        return this.platformer.buildPlatform(this, floor, this.getEventMaterial(), this.getActionMaterial());
    }

    public boolean setEventMaterial(Material event) {
        if (this.cantBePlatformMaterial(event)) {
            return false;
        }
        if (event == this.getFloorMaterial()) {
            return false;
        }
        if (event == this.getActionMaterial()) {
            return false;
        }
        return this.platformer.buildPlatform(this, this.getFloorMaterial(), event, this.getActionMaterial());
    }

    public boolean setActionMaterial(Material action) {
        if (this.cantBePlatformMaterial(action)) {
            return false;
        }
        if (action == this.getEventMaterial()) {
            return false;
        }
        if (action == this.getActionMaterial()) {
            return false;
        }
        return this.platformer.buildPlatform(this, this.getFloorMaterial(), this.getEventMaterial(), action);
    }

    public void setContainerMaterial(Material containerMaterial) {
        Location begin = this.platformer.getPlatformBeginLocation(this);
        Location end = this.platformer.getPlatformEndLocation(this);
        for (int z = begin.getBlockZ() + 4; z < end.getBlockZ() - 4; z += 4) {
            for (int x = begin.getBlockX() + 6; x <= end.getBlockX() - 4; x += 2) {
                Block containerBlock = new Location(this.getWorld(), (double)x, 2.0, (double)z).getBlock();
                BlockState blockState = containerBlock.getState();
                if (!(blockState instanceof InventoryHolder)) continue;
                InventoryHolder container = (InventoryHolder)blockState;
                ItemStack[] data = container.getInventory().getContents();
                containerBlock.setType(containerMaterial);
                ((Container)containerBlock.getState()).getInventory().setContents(data);
                BlockData blockData = containerBlock.getBlockData();
                ((Directional)blockData).setFacing(BlockFace.SOUTH);
                containerBlock.setBlockData(blockData);
                containerBlock.getState().update();
            }
        }
    }

    public void setSignMaterial(Material signMaterial) {
        Location begin = this.platformer.getPlatformBeginLocation(this);
        Location end = this.platformer.getPlatformEndLocation(this);
        for (int z = begin.getBlockZ() + 5; z < end.getBlockZ() - 4; z += 4) {
            for (int x = begin.getBlockX() + 4; x <= end.getBlockX() - 4; x += 2) {
                Block signBlock = new Location(this.getWorld(), (double)x, 1.0, (double)z).getBlock();
                if (!signBlock.getType().name().contains("WALL_SIGN")) continue;
                Sign oldSign = (Sign)signBlock.getState();
                signBlock.setType(signMaterial);
                Sign sign = (Sign)signBlock.getState();
                for (int i = 0; i < oldSign.getSide(Side.FRONT).lines().size(); i = (int)((byte)(i + 1))) {
                    sign.getSide(Side.FRONT).line(i, oldSign.getSide(Side.FRONT).line(i));
                }
                sign.getSide(Side.FRONT).setGlowingText(oldSign.getSide(Side.FRONT).isGlowingText());
                BlockData blockData = signBlock.getBlockData();
                ((Directional)blockData).setFacing(BlockFace.SOUTH);
                sign.setBlockData(blockData);
                sign.update();
                PlayerUtils.translateBlockSign(signBlock);
            }
        }
    }

    public List<Location> getPlacedExecutors(ExecutorCategory category) {
        Location begin = this.platformer.getPlatformBeginLocation(this);
        Location end = this.platformer.getPlatformEndLocation(this);
        ArrayList<Location> locations = new ArrayList<Location>();
        for (int z = begin.getBlockZ() + 4; z <= end.getBlockZ() - 4; z += 4) {
            Block block = this.getWorld().getBlockAt(begin.getBlockX() + 4, 1, z);
            ExecutorCategory blockCategory = ExecutorCategory.getByMaterial(block.getType());
            if (blockCategory != category) continue;
            locations.add(block.getLocation());
        }
        return locations;
    }

    public int getBeginCoordinate() {
        return this.platformer.getPlatformBeginLocation(this).getBlockX();
    }

    public int getEndCoordinate() {
        return this.platformer.getPlatformEndLocation(this).getBlockX();
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public World getWorld() {
        return this.world;
    }

    public Location getSpawnLocation() {
        Location spawn = this.platformer.getPlatformBeginLocation(this).clone();
        spawn.add(2.5, 1.0, 2.5);
        spawn.setYaw(-45.0f);
        spawn.setPitch(0.0f);
        return spawn;
    }

    public String toString() {
        return "DevPlatform x: " + this.x + " z: " + this.z;
    }
}

