/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodingBlockParser;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.JoinEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.GamePlayEvent;
import ua.mcchickenstudio.opencreative.coding.variables.WorldVariables;
import ua.mcchickenstudio.opencreative.events.planet.PlanetConnectPlayerEvent;
import ua.mcchickenstudio.opencreative.listeners.player.ChangedWorld;
import ua.mcchickenstudio.opencreative.managers.stability.StabilityState;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.PlanetExperiments;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.planets.PlanetInfo;
import ua.mcchickenstudio.opencreative.planets.PlanetLimits;
import ua.mcchickenstudio.opencreative.planets.PlanetPlayers;
import ua.mcchickenstudio.opencreative.planets.PlanetTerritory;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.settings.groups.Group;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.hooks.HookUtils;

public class Planet {
    private final int id;
    private String owner;
    private String ownerGroup;
    private final PlanetInfo info;
    private final DevPlanet devPlanet;
    private final PlanetLimits limits;
    private final PlanetTerritory territory;
    private final PlanetPlayers worldPlayers;
    private final WorldVariables variables;
    private final PlanetExperiments experiments;
    private long creationTime;
    private long lastActivityTime;
    private Mode mode;
    private Sharing sharing;
    private boolean debug;
    private boolean corrupted;
    private boolean changingOwner;

    public Planet(int id) {
        this.id = id;
        this.devPlanet = new DevPlanet(this);
        this.info = new PlanetInfo(this);
        this.loadInfo();
        this.worldPlayers = new PlanetPlayers(this);
        this.limits = new PlanetLimits(this);
        this.territory = new PlanetTerritory(this);
        this.variables = new WorldVariables(this);
        this.experiments = new PlanetExperiments(this);
        OpenCreative.getPlanetsManager().registerPlanet(this);
        this.info.updateIconAsync();
    }

    public PlanetInfo getInformation() {
        return this.info;
    }

    public PlanetPlayers getWorldPlayers() {
        return this.worldPlayers;
    }

    public boolean isOwner(Player player) {
        return this.getOwner().equalsIgnoreCase(player.getName());
    }

    public boolean isOwner(String nickname) {
        return this.getOwner().equalsIgnoreCase(nickname);
    }

    public void setMode(Mode mode) {
        if (this.mode == mode) {
            return;
        }
        FileUtils.setPlanetConfigParameter(this, "mode", mode.name());
        if (!this.isLoaded()) {
            this.mode = mode;
            return;
        }
        try {
            this.territory.getWorld().getSpawnLocation().getChunk().load(true);
            if (mode == Mode.BUILD) {
                for (Player player : this.getPlayers()) {
                    if (!PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                        new QuitEvent(player).callEvent();
                        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.build-mode.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.build-mode.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(100L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(130L))));
                        PlayerUtils.clearPlayer(player);
                        player.teleport(this.territory.getWorld().getSpawnLocation());
                        Sounds.WORLD_MODE_BUILD.play((Audience)player);
                        this.territory.showBorders(player);
                        if (this.isOwner(player)) {
                            player.getInventory().setItem(8, ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings"));
                        }
                        if (this.worldPlayers.canBuild(player)) {
                            player.setGameMode(GameMode.CREATIVE);
                            PlayerUtils.giveBuildPermissions(player);
                            player.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.message.owner"));
                            if (this.territory.isAutoSave()) continue;
                            player.sendMessage(MessageUtils.getLocaleMessage("settings.autosave.warning"));
                            continue;
                        }
                        player.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.message.players"));
                        continue;
                    }
                    player.sendMessage(MessageUtils.getLocaleMessage("world.build-mode.message.players"));
                }
                this.territory.stopBukkitRunnables();
                HookUtils.clearEntitiesHook(this.territory.getWorld());
            } else {
                this.mode = mode;
                this.territory.stopBukkitRunnables();
                HookUtils.clearEntitiesHook(this.territory.getWorld());
                for (Player player : this.getPlayers()) {
                    if (!PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                        PlayerUtils.clearPlayer(player);
                        player.clearTitle();
                        player.teleport(this.territory.getWorld().getSpawnLocation());
                        this.territory.showBorders(player);
                        if (this.worldPlayers.canDevelop(player)) {
                            player.sendMessage(MessageUtils.getLocaleMessage("world.play-mode.message.owner"));
                            continue;
                        }
                        player.sendMessage(MessageUtils.getLocaleMessage("world.play-mode.message.players"));
                        continue;
                    }
                    player.sendMessage(MessageUtils.getLocaleMessage("world.play-mode.message.owner"));
                }
                if (this.devPlanet.isLoaded()) {
                    new CodingBlockParser(this.devPlanet).parseCode(this.devPlanet);
                } else {
                    this.territory.getScript().loadCode();
                }
                new GamePlayEvent(this).callEvent();
                for (Player player : this.getPlayers()) {
                    if (OpenCreative.getPlanetsManager().getDevPlanet(player) != null) continue;
                    new JoinEvent(player).callEvent();
                }
            }
        }
        catch (Exception error) {
            ErrorUtils.sendPlanetErrorMessage(this, "Failed to change mode to " + mode.name());
        }
        this.mode = mode;
    }

    public Sharing getSharing() {
        return this.sharing;
    }

    public void setSharing(Sharing sharing) {
        if (this.sharing == sharing) {
            return;
        }
        this.sharing = sharing;
        FileUtils.setPlanetConfigParameter(this, "sharing", sharing.name());
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getWorldName() {
        return "./planets/planet" + this.id;
    }

    public int getId() {
        return this.id;
    }

    public DevPlanet getDevPlanet() {
        return this.devPlanet;
    }

    public boolean isChangingOwner() {
        return this.changingOwner;
    }

    public void setChangingOwner(boolean changingOwner) {
        this.changingOwner = changingOwner;
    }

    public PlanetTerritory getTerritory() {
        return this.territory;
    }

    public boolean isLoaded() {
        return Bukkit.getWorld((String)this.getWorldName()) != null;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.getWorldName());
    }

    public void loadInfo() {
        FileConfiguration config = FileUtils.getPlanetConfig(this);
        String owner = "Unknown owner";
        String ownerGroup = "default";
        Mode mode = Mode.BUILD;
        Sharing sharing = Sharing.PRIVATE;
        if (config.getString("owner") != null) {
            owner = config.getString("owner");
        } else {
            this.corrupted = true;
        }
        if (config.getString("owner-group") != null) {
            ownerGroup = config.getString("owner-group");
        }
        if (config.getString("mode") != null) {
            try {
                mode = Mode.valueOf(config.getString("mode"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.getString("sharing") != null) {
            try {
                sharing = Sharing.valueOf(config.getString("sharing"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.get("creation-time") != null) {
            try {
                this.creationTime = Long.parseLong(String.valueOf(config.get("creation-time")));
            }
            catch (Exception error) {
                this.creationTime = 1670573410000L;
            }
        }
        if (config.get("last-activity-time") != null) {
            try {
                this.lastActivityTime = Long.parseLong(String.valueOf(config.get("last-activity-time")));
            }
            catch (Exception error) {
                this.lastActivityTime = 1670573410000L;
            }
        }
        if (this.corrupted) {
            ErrorUtils.sendCriticalErrorMessage("Planet " + this.id + " lost it's config file, please check planet files in " + this.getWorldName());
        }
        this.owner = owner;
        this.ownerGroup = ownerGroup;
        this.mode = mode;
        this.sharing = sharing;
    }

    public byte getFlagValue(PlanetFlags.PlanetFlag flag) {
        return this.territory.getFlags().getFlagValue(flag);
    }

    public void setFlagValue(PlanetFlags.PlanetFlag flag, byte value) {
        this.territory.getFlags().setFlag(flag, value);
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getOnline() {
        return this.getPlayers().size();
    }

    public long getCreationTime() {
        if (this.creationTime == 0L) {
            return 1670573410000L;
        }
        return this.creationTime;
    }

    public long getLastActivityTime() {
        if (this.lastActivityTime == 0L) {
            return 1670573410000L;
        }
        return this.lastActivityTime;
    }

    public List<Player> getPlayers() {
        ArrayList<Player> playerList = new ArrayList<Player>();
        if (!this.isLoaded()) {
            return playerList;
        }
        playerList.addAll(this.territory.getWorld().getPlayers());
        if (this.getDevPlanet().isLoaded()) {
            playerList.addAll(this.getDevPlanet().getWorld().getPlayers());
        }
        return playerList;
    }

    public Audience getAudience() {
        Audience audience = Audience.empty();
        if (this.isLoaded()) {
            audience = Audience.audience((Audience[])new Audience[]{this.territory.getWorld()});
            if (this.devPlanet.isLoaded()) {
                audience = Audience.audience((Audience[])new Audience[]{this.territory.getWorld(), this.devPlanet.getWorld()});
            }
        }
        return audience;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getOwnerGroup() {
        return this.ownerGroup;
    }

    public void connectPlayer(Player player) {
        this.connectPlayer(player, false);
    }

    public void connectPlayer(Player player, boolean hidePlayer) {
        if (OpenCreative.getStability().getState() != StabilityState.FINE && !this.isLoaded()) {
            player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
            Sounds.PLAYER_FAIL.play((Audience)player);
            return;
        }
        if (!this.isOwner(player.getName())) {
            if (this.getSharing() != Sharing.PUBLIC && !player.hasPermission("opencreative.world.private.bypass") && !this.worldPlayers.isWhitelisted(player.getName())) {
                player.sendMessage(MessageUtils.getPlayerLocaleMessage("private-planet", (OfflinePlayer)player));
                return;
            }
            if (this.worldPlayers.isBanned(player.getName()) && !player.hasPermission("opencreative.world.banned.bypass")) {
                player.sendMessage(MessageUtils.getPlayerLocaleMessage("blacklisted-in-planet", (OfflinePlayer)player));
                return;
            }
        }
        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.connecting.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.connecting.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(710L), (Duration)Duration.ofSeconds(30L), (Duration)Duration.ofMillis(130L))));
        Sounds.WORLD_CONNECTION.play((Audience)player);
        boolean wasLoaded = this.isLoaded();
        if (!this.isLoaded()) {
            OpenCreative.getPlugin().getLogger().info("Loading planet " + this.id + " and teleporting " + player.getName());
            this.territory.load();
        } else {
            OpenCreative.getPlugin().getLogger().info("Planet " + this.id + " is already loaded, teleporting " + player.getName());
        }
        player.teleportAsync(this.territory.getWorld().getSpawnLocation()).thenAccept(success -> {
            PlayerUtils.clearPlayer(player);
            if (success.booleanValue()) {
                ItemStack worldSettingsItem;
                if (!hidePlayer && this.getFlagValue(PlanetFlags.PlanetFlag.JOIN_MESSAGES) == 1) {
                    for (Player onlinePlayer : this.getPlayers()) {
                        onlinePlayer.sendMessage(MessageUtils.getPlayerLocaleMessage("world.joined", (OfflinePlayer)player));
                    }
                }
                PlayerUtils.clearPlayer(player);
                Sounds.WORLD_CONNECTED.play((Audience)player);
                this.mode.onPlayerConnect(player, this);
                this.getWorldPlayers().getPlanetPlayer(player).load();
                player.clearTitle();
                this.territory.showBorders(player);
                if (!FileUtils.getPlayersFromPlanetList(this, PlayersType.UNIQUE).contains(player.getName())) {
                    FileUtils.addPlayerInPlanetList(this, player.getName(), PlayersType.UNIQUE);
                    this.info.setUniques(this.info.getUniques() + 1);
                    if (this.isOwner(player)) {
                        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getPlayerLocaleMessage("creating-world.welcome-title", (OfflinePlayer)player)), (Component)MessageUtils.toComponent(MessageUtils.getPlayerLocaleMessage("creating-world.welcome-subtitle", (OfflinePlayer)player)), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(9L), (Duration)Duration.ofSeconds(2L))));
                        player.sendMessage(MessageUtils.getLocaleMessage("creating-world.welcome"));
                        Sounds.WELCOME_TO_NEW_WORLD.play((Audience)player);
                        player.setGameMode(GameMode.CREATIVE);
                        worldSettingsItem = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                        player.getInventory().setItem(8, worldSettingsItem);
                    }
                } else if (this.isOwner(player) && this.getFlagValue(PlanetFlags.PlanetFlag.JOIN_MESSAGES) == 1) {
                    player.sendMessage(MessageUtils.getPlayerLocaleMessage("world.connecting.owner-help", (OfflinePlayer)player));
                }
                if (this.isOwner(player.getName())) {
                    this.ownerGroup = OpenCreative.getSettings().getGroups().getGroup(player).getName().toLowerCase();
                    worldSettingsItem = ItemUtils.createItem(Material.COMPASS, 1, "items.developer.world-settings");
                    player.getInventory().setItem(8, worldSettingsItem);
                    if (this.getDevPlanet().isLoaded() && OpenCreative.getStability().isFine()) {
                        new CodingBlockParser(this.devPlanet).parseCode(this.getDevPlanet());
                    }
                }
                if (!this.territory.isAutoSave() && this.worldPlayers.canBuild(player)) {
                    player.sendMessage(MessageUtils.getLocaleMessage("settings.autosave.warning"));
                }
                if (!wasLoaded) {
                    this.territory.getScript().loadCode();
                    new GamePlayEvent(this).callEvent();
                }
                if (this.mode == Mode.PLAYING && this.worldPlayers.canDevelop(player)) {
                    PlayerUtils.givePlayPermissions(player);
                } else if (this.mode == Mode.BUILD && this.worldPlayers.canBuild(player)) {
                    PlayerUtils.giveBuildPermissions(player);
                }
                if (!hidePlayer) {
                    new JoinEvent(player).callEvent();
                } else {
                    player.setGameMode(GameMode.SPECTATOR);
                    ChangedWorld.addPlayerWithLocation(player);
                    for (Player onlinePlayer : this.getPlayers()) {
                        onlinePlayer.hidePlayer((Plugin)OpenCreative.getPlugin(), player);
                    }
                }
                new PlanetConnectPlayerEvent(this, player).callEvent();
                this.info.updateIconAsync();
            } else {
                ErrorUtils.sendPlayerErrorMessage(player, "Can't join planet. World is unloaded.");
            }
        });
    }

    public void connectToDevPlanet(Player player) {
        this.connectToDevPlanet(player, false);
    }

    public void connectToDevPlanet(final Player player, boolean hidePlayer) {
        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.connecting.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.connecting.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(15L), (Duration)Duration.ofSeconds(9999L), (Duration)Duration.ofSeconds(10L))));
        this.getDevPlanet().loadDevPlanetWorld();
        this.getDevPlanet().getWorld().getSpawnLocation().getChunk().load(true);
        Location lastLocation = this.getDevPlanet().getLastLocations().get(player);
        if (!this.getDevPlanet().isLoaded()) {
            return;
        }
        if (lastLocation == null || !this.devPlanet.isSaveLocation()) {
            lastLocation = this.getDevPlanet().getWorld().getSpawnLocation();
        }
        player.teleportAsync(lastLocation).thenAccept(success -> {
            if (success.booleanValue()) {
                if (!hidePlayer) {
                    for (Player onlinePlayer : player.getWorld().getPlayers()) {
                        onlinePlayer.sendMessage(MessageUtils.getPlayerLocaleMessage("world.dev-mode.joined", (OfflinePlayer)player));
                    }
                } else {
                    player.setGameMode(GameMode.SPECTATOR);
                    for (Player onlinePlayer : player.getWorld().getPlayers()) {
                        onlinePlayer.hidePlayer((Plugin)OpenCreative.getPlugin(), player);
                    }
                }
                if (this.devPlanet.isSaveLocation()) {
                    this.devPlanet.getLastLocations().put(player, player.getLocation());
                }
                if (this.devPlanet.isNightVision()) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, 0, false, false, false));
                }
                Sounds.DEV_CONNECTED.play((Audience)player);
                Sounds.WORLD_MODE_DEV.play((Audience)player);
                this.devPlanet.displayWorldBorders();
                player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("world.dev-mode.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMillis(750L))));
                BukkitRunnable translation = new BukkitRunnable(){

                    public void run() {
                        if (Planet.this.getDevPlanet().getWorld() == null) {
                            return;
                        }
                        Planet.this.getDevPlanet().translateCodingBlocks(player);
                        Planet.this.territory.removeBukkitRunnable(this);
                    }
                };
                this.territory.addBukkitRunnable(translation);
                translation.runTaskLater((Plugin)OpenCreative.getPlugin(), 5L);
            }
        });
    }

    public void connectToDevPlanet(Player player, double x, double y, double z) {
        this.connectToDevPlanet(player);
        if (x > 0.0 && y > 0.0 && z > 0.0 && y < 30.0 && !BlockUtils.isOutOfBorders(new Location(this.devPlanet.getWorld(), x + 1.0, y, z + 2.0))) {
            Location location = new Location(this.getDevPlanet().getWorld(), x + 1.0, y, z + 2.0, 180.0f, 5.0f);
            player.teleportAsync(location).thenAccept(success -> {
                if (success.booleanValue()) {
                    PlayerUtils.spawnGlowingBlock(player, new Location(this.getDevPlanet().getWorld(), x + 0.5, y, z + 0.5));
                }
            });
        }
    }

    public void setLastActivityTime(long activityTime) {
        this.lastActivityTime = activityTime;
        FileUtils.setPlanetConfigParameter(this, "last-activity-time", activityTime);
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
        FileUtils.setPlanetConfigParameter(this, "creation-time", creationTime);
        this.info.updateIconAsync();
    }

    public void setOwner(String owner) {
        this.owner = owner;
        FileUtils.setPlanetConfigParameter(this, "owner", owner);
        FileUtils.setPlanetConfigParameter(this, "owner-uuid", Bukkit.getOfflinePlayer((String)owner).getUniqueId().toString());
        this.info.updateIconAsync();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public WorldVariables getVariables() {
        return this.variables;
    }

    public boolean isCorrupted() {
        return this.corrupted;
    }

    public PlanetLimits getLimits() {
        return this.limits;
    }

    public PlanetExperiments getExperiments() {
        return this.experiments;
    }

    public Group getGroup() {
        return OpenCreative.getSettings().getGroups().getGroup(this.ownerGroup);
    }

    public static enum Mode {
        PLAYING{

            @Override
            public void onPlayerConnect(Player player, Planet planet) {
                player.setGameMode(GameMode.ADVENTURE);
            }
        }
        ,
        BUILD{

            @Override
            public void onPlayerConnect(Player player, Planet planet) {
                if (planet.getWorldPlayers().canBuild(player)) {
                    player.setGameMode(GameMode.CREATIVE);
                    PlayerUtils.giveBuildPermissions(player);
                }
            }
        };


        public String getName() {
            return MessageUtils.getLocaleMessage("world." + (this == PLAYING ? "play-mode" : "build-mode") + ".name", false);
        }

        public void onPlayerConnect(Player player, Planet planet) {
        }
    }

    public static enum Sharing {
        PUBLIC,
        PRIVATE,
        CLOSED;


        public String getName() {
            return MessageUtils.getLocaleMessage("world.sharing." + (this == PUBLIC ? "public" : "private"), false);
        }
    }

    public static enum PlayersType {
        UNIQUE("players.unique"),
        LIKED("players.liked"),
        DISLIKED("players.disliked"),
        WHITELISTED("players.whitelist"),
        BLACKLISTED("players.blacklist"),
        BUILDERS_TRUSTED("players.builders.trusted"),
        BUILDERS_NOT_TRUSTED("players.builders.not-trusted"),
        DEVELOPERS_TRUSTED("players.developers.trusted"),
        DEVELOPERS_NOT_TRUSTED("players.developers.not-trusted"),
        DEVELOPERS_GUESTS("players.developers.guests");

        private final String path;

        private PlayersType(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }
    }
}

