/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.ArrayList;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class PlanetInfo {
    private final Planet planet;
    private String displayName;
    private String description;
    private String customID;
    private int uniques;
    private int reputation;
    private Category category;
    private ItemStack icon;
    private boolean downloadable;

    public PlanetInfo(Planet planet) {
        this.planet = planet;
        this.loadInformation();
    }

    public void loadInformation() {
        FileConfiguration config = FileUtils.getPlanetConfig(this.planet);
        String name = "Unknown name";
        String description = "World data is corrupted,\\nplease report server admin\\nabout this world.";
        String customID = String.valueOf(this.planet.getId());
        Category category = Category.SANDBOX;
        ItemStack icon = new ItemStack(Material.REDSTONE);
        boolean downloadable = false;
        this.reputation = FileUtils.getPlayersFromPlanetList(this.planet, Planet.PlayersType.LIKED).size() - FileUtils.getPlayersFromPlanetList(this.planet, Planet.PlayersType.DISLIKED).size();
        this.uniques = FileUtils.getPlayersFromPlanetList(this.planet, Planet.PlayersType.UNIQUE).size();
        if (config.getString("name") != null) {
            name = config.getString("name");
        }
        if (config.getString("description") != null) {
            description = config.getString("description");
        }
        if (config.getString("customID") != null) {
            customID = config.getString("customID");
        }
        if (config.getString("category") != null) {
            try {
                category = Category.valueOf(config.getString("category"));
            }
            catch (Exception error) {
                category = Category.SANDBOX;
            }
        }
        if (config.get("icon") != null) {
            try {
                icon = config.isString("icon") ? new ItemStack(Material.valueOf((String)config.getString("icon"))) : ItemStack.deserialize((Map)config.getConfigurationSection("icon").getValues(true));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (config.getString("downloadable") != null) {
            downloadable = config.getBoolean("downloadable");
        }
        this.displayName = name;
        this.description = description;
        this.category = category;
        this.customID = customID;
        this.downloadable = downloadable;
        this.icon = icon;
    }

    public void updateIconAsync() {
        new BukkitRunnable(){

            public void run() {
                PlanetInfo.this.updateIcon();
            }
        }.runTaskAsynchronously((Plugin)OpenCreative.getPlugin());
    }

    public void updateIcon() {
        ItemStack item = this.icon.clone();
        ItemMeta meta = item.getItemMeta();
        meta.displayName(MessageUtils.getLocaleComponent("menus.all-worlds.items.world.name").replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetName%").replacement((ComponentLike)this.displayName()).build()));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.all-worlds.items.world.lore")) {
            if (loreLine.contains("%planetDescription%")) {
                String[] newLines;
                for (String newLine : newLines = this.description.split("\\\\n")) {
                    lore.add(loreLine.replace("%planetDescription%", ChatColor.translateAlternateColorCodes((char)'&', (String)newLine)));
                }
                continue;
            }
            lore.add(MessageUtils.parsePlanetLines(this.planet, loreLine));
        }
        item.setAmount(Math.max(this.planet.getOnline(), 1));
        meta.setLore(lore);
        item.setItemMeta(meta);
        ItemUtils.clearItemFlags(item);
        ItemUtils.setPersistentData(item, ItemUtils.getItemIdKey(), this.customID);
        this.icon = item;
    }

    public void setCategory(Category category) {
        this.category = category;
        FileUtils.setPlanetConfigParameter(this.planet, "category", category.toString());
    }

    public void setDisplayName(String name) {
        this.displayName = name;
        FileUtils.setPlanetConfigParameter(this.planet, "name", name);
    }

    public void setDescription(String description) {
        this.description = description;
        FileUtils.setPlanetConfigParameter(this.planet, "description", description);
    }

    public void setIcon(ItemStack itemStack) {
        ItemStack newIcon = ItemUtils.clearItemMeta(itemStack.clone());
        newIcon.setAmount(1);
        FileUtils.setPlanetConfigParameter(this.planet, "icon", newIcon.serialize());
        this.icon = newIcon;
        this.updateIcon();
    }

    public void setCustomID(String customID) {
        this.customID = customID;
        FileUtils.setPlanetConfigParameter(this.planet, "customID", customID);
    }

    public Component displayName() {
        return LegacyComponentSerializer.legacySection().deserialize(this.displayName).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE);
    }

    public Component description() {
        return LegacyComponentSerializer.legacySection().deserialize(this.description);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getCustomID() {
        return this.customID;
    }

    public ItemStack getIcon() {
        if (this.planet.getSharing() == Planet.Sharing.PUBLIC) {
            return this.icon;
        }
        return this.icon.clone().withType(Material.BARRIER);
    }

    public int getUniques() {
        return this.uniques;
    }

    public void setUniques(int uniques) {
        this.uniques = uniques;
    }

    public int getReputation() {
        return this.reputation;
    }

    public void setPlanetReputation(int reputation) {
        this.reputation = reputation;
    }

    public boolean isDownloadable() {
        return this.downloadable;
    }

    public void setDownloadable(boolean downloadable) {
        this.downloadable = downloadable;
        FileUtils.setPlanetConfigParameter(this.planet, "downloadable", downloadable);
    }

    public static enum Category {
        SANDBOX(Material.YELLOW_CONCRETE_POWDER),
        ADVENTURE(Material.NETHERITE_BOOTS),
        STRATEGY(Material.ZOMBIE_HEAD),
        ARCADE(Material.HEART_OF_THE_SEA),
        ROLEPLAY(Material.CHERRY_CHEST_BOAT),
        STORY(Material.WRITABLE_BOOK),
        SIMULATOR(Material.NETHERITE_PICKAXE),
        EXPERIMENT(Material.TNT_MINECART);

        private final Material material;

        private Category(Material material) {
            this.material = material;
        }

        public Material getMaterial() {
            return this.material;
        }

        public String getLocaleName() {
            return MessageUtils.getLocaleMessage("world.categories." + this.name().toLowerCase());
        }
    }
}

