/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.groups.LimitType;

public class PlanetLimits {
    private final Planet planet;
    private int lastModifiedBlocksAmount;
    private int lastRedstoneOperationsAmount;
    private int lastListElementsChangesAmount;
    private final LinkedList<Long> lastWebRequests = new LinkedList();
    private final LinkedList<Long> lastLightningsStrikes = new LinkedList();
    private final LinkedList<Long> lastBeesSpawns = new LinkedList();
    private final Map<UUID, Deque<Long>> lastPlayerMenuOpens = new HashMap<UUID, Deque<Long>>();

    public PlanetLimits(Planet planet) {
        this.planet = planet;
    }

    public int getVariablesAmountLimit() {
        return this.planet.getGroup().getLimit(LimitType.VARIABLES).calculateLimit(this.planet.getPlayers().size());
    }

    public int getModifyingBlocksLimit() {
        return this.planet.getGroup().getLimit(LimitType.MODIFYING_BLOCKS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getBuildersLimit() {
        return this.planet.getGroup().getLimit(LimitType.BUILDERS_AMOUNT).calculateLimit(this.planet.getPlayers().size());
    }

    public int getDevelopersLimit() {
        return this.planet.getGroup().getLimit(LimitType.DEVELOPERS_AMOUNT).calculateLimit(this.planet.getPlayers().size());
    }

    public int getBlacklistedLimit() {
        return this.planet.getGroup().getLimit(LimitType.BLACKLISTED_AMOUNT).calculateLimit(this.planet.getPlayers().size());
    }

    public int getWhitelistedLimit() {
        return this.planet.getGroup().getLimit(LimitType.WHITELISTED_AMOUNT).calculateLimit(this.planet.getPlayers().size());
    }

    public int getRedstoneOperationsLimit() {
        return this.planet.getGroup().getLimit(LimitType.REDSTONE_OPERATIONS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getRepeatsAmountLimit() {
        return this.planet.getGroup().getLimit(LimitType.REPEATS_AMOUNT).calculateLimit(this.planet.getPlayers().size());
    }

    public int getCodeOperationsLimit() {
        return this.planet.getGroup().getLimit(LimitType.CODE_OPERATIONS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getOpeningInventoriesLimit() {
        return this.planet.getGroup().getLimit(LimitType.OPENING_INVENTORIES).calculateLimit(this.planet.getPlayers().size());
    }

    public int getWebRequestsLimit() {
        return this.planet.getGroup().getLimit(LimitType.SENDING_WEB_REQUESTS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getEntitiesLimit() {
        return this.planet.getGroup().getLimit(LimitType.ENTITIES).calculateLimit(this.planet.getPlayers().size());
    }

    public int getScoreboardsLimit() {
        return this.planet.getGroup().getLimit(LimitType.SCOREBOARDS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getVariableElementsChangesLimit() {
        return this.planet.getGroup().getLimit(LimitType.SCOREBOARDS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getBossBarsLimit() {
        return this.planet.getGroup().getLimit(LimitType.BOSSBARS).calculateLimit(this.planet.getPlayers().size());
    }

    public int getPhysicalObjectsLimit() {
        return this.planet.getGroup().getLimit(LimitType.PHYSICAL_OBJECTS).calculateLimit(this.planet.getPlayers().size());
    }

    public void setLastVariableElementsChangesAmount(int changedElementsAmount) {
        this.lastListElementsChangesAmount = changedElementsAmount;
    }

    public void setLastModifiedBlocksAmount(int lastModifiedBlocksAmount) {
        this.lastModifiedBlocksAmount = lastModifiedBlocksAmount;
    }

    public void setLastRedstoneOperationsAmount(int lastRedstoneOperationsAmount) {
        this.lastRedstoneOperationsAmount = lastRedstoneOperationsAmount;
    }

    public int getLastModifiedBlocksAmount() {
        return this.lastModifiedBlocksAmount;
    }

    public int getLastRedstoneOperationsAmount() {
        return this.lastRedstoneOperationsAmount;
    }

    public int getLastVariableElementsChangesAmount() {
        return this.lastListElementsChangesAmount;
    }

    public int getCodingPlatformsLimit() {
        return this.planet.getGroup().getCodingPlatformsLimit();
    }

    public boolean canLightningStrike() {
        long now = System.currentTimeMillis();
        while (!this.lastLightningsStrikes.isEmpty() && now - this.lastLightningsStrikes.peek() > 5000L) {
            this.lastLightningsStrikes.poll();
        }
        if (this.lastLightningsStrikes.size() >= 5) {
            return false;
        }
        this.lastLightningsStrikes.add(now);
        return true;
    }

    public boolean canBeeSpawnFromBeehive() {
        long now = System.currentTimeMillis();
        while (!this.lastBeesSpawns.isEmpty() && now - this.lastBeesSpawns.peek() > 5000L) {
            this.lastBeesSpawns.poll();
        }
        if (this.lastBeesSpawns.size() >= 5) {
            return false;
        }
        this.lastBeesSpawns.add(now);
        return true;
    }

    public boolean canSendWebRequest() {
        long now = System.currentTimeMillis();
        while (!this.lastWebRequests.isEmpty() && now - this.lastWebRequests.peek() > 5000L) {
            this.lastWebRequests.poll();
        }
        if (this.lastWebRequests.size() >= this.getWebRequestsLimit()) {
            return false;
        }
        this.lastWebRequests.add(now);
        return true;
    }

    public boolean cantOpenMenu(Player player) {
        for (UUID uuid : this.lastPlayerMenuOpens.keySet()) {
            if (Bukkit.getPlayer((UUID)uuid) != null) continue;
            this.lastPlayerMenuOpens.remove(uuid);
        }
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        this.lastPlayerMenuOpens.putIfAbsent(uuid, new LinkedList());
        Deque<Long> timestamps = this.lastPlayerMenuOpens.get(uuid);
        while (!timestamps.isEmpty() && now - timestamps.peekFirst() > 5000L) {
            timestamps.pollFirst();
        }
        if (timestamps.size() >= this.getOpeningInventoriesLimit()) {
            return true;
        }
        timestamps.addLast(now);
        return false;
    }

    public void clearPlayerLimits(Player player) {
        this.lastPlayerMenuOpens.remove(player.getUniqueId());
    }

    public void clear() {
        this.lastModifiedBlocksAmount = 0;
        this.lastRedstoneOperationsAmount = 0;
        this.lastListElementsChangesAmount = 0;
        this.lastLightningsStrikes.clear();
        this.lastBeesSpawns.clear();
        this.lastPlayerMenuOpens.clear();
        this.lastWebRequests.clear();
    }
}

