/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.FileUtils;

public class PlanetPlayer {
    private final Planet currentPlanet;
    private final Player player;
    private final Set<String> purchases;
    private final ItemStack[] savedInventory;
    private final ItemStack[] savedEnderChest;

    public PlanetPlayer(@NotNull Planet currentPlanet, @NotNull Player player) {
        if (currentPlanet == null) {
            PlanetPlayer.$$$reportNull$$$0(0);
        }
        if (player == null) {
            PlanetPlayer.$$$reportNull$$$0(1);
        }
        this.purchases = new HashSet<String>();
        this.savedInventory = new ItemStack[41];
        this.savedEnderChest = new ItemStack[54];
        this.currentPlanet = currentPlanet;
        this.player = player;
    }

    @NotNull
    public Planet getCurrentPlanet() {
        Planet planet = this.currentPlanet;
        if (planet == null) {
            PlanetPlayer.$$$reportNull$$$0(2);
        }
        return planet;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack[] getSavedInventory() {
        return this.savedInventory;
    }

    public ItemStack[] getSavedEnderChest() {
        return this.savedEnderChest;
    }

    public void saveInventory(ItemStack[] items) {
        Arrays.fill(this.savedInventory, new ItemStack(Material.AIR));
        int slot = 0;
        for (ItemStack item : items) {
            if (this.savedInventory.length == slot) break;
            this.savedInventory[slot] = item;
            ++slot;
        }
    }

    public void saveEnderChest(ItemStack[] items) {
        Arrays.fill(this.savedEnderChest, null);
        int slot = 0;
        for (ItemStack item : items) {
            if (this.savedEnderChest.length == slot) break;
            this.savedEnderChest[slot] = item;
            ++slot;
        }
    }

    public boolean load() {
        boolean bl;
        File playerDataJson = FileUtils.getPlayerDataJson(this.currentPlanet, this.player);
        if (playerDataJson == null) {
            return false;
        }
        if (playerDataJson.length() == 0L) {
            return true;
        }
        JSONParser parser = new JSONParser();
        FileReader fileReader = new FileReader(playerDataJson);
        try {
            Object savedEnderChest;
            Object savedInventory;
            JSONObject playerObject = (JSONObject)parser.parse((Reader)fileReader);
            Object purchases = playerObject.getOrDefault((Object)"purchases", (Object)new JSONArray());
            if (purchases instanceof JSONArray) {
                JSONArray array = (JSONArray)purchases;
                this.purchases.addAll((Collection<String>)array);
            }
            if ((savedInventory = playerObject.getOrDefault((Object)"saved-inventory", (Object)new JSONArray())) instanceof JSONArray) {
                JSONArray array = (JSONArray)savedInventory;
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Object object : array) {
                    ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)((String)object)));
                    BukkitObjectInputStream objectInputStream = new BukkitObjectInputStream((InputStream)arrayInputStream);
                    items.add((ItemStack)objectInputStream.readObject());
                }
                this.saveInventory(items.toArray(new ItemStack[0]));
            }
            if ((savedEnderChest = playerObject.getOrDefault((Object)"saved-ender-chest", (Object)new JSONArray())) instanceof JSONArray) {
                JSONArray array = (JSONArray)savedEnderChest;
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                for (Object object : array) {
                    ByteArrayInputStream arrayInputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)((String)object)));
                    BukkitObjectInputStream objectInputStream = new BukkitObjectInputStream((InputStream)arrayInputStream);
                    items.add((ItemStack)objectInputStream.readObject());
                }
                this.saveEnderChest(items.toArray(new ItemStack[0]));
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ErrorUtils.sendCriticalErrorMessage("Couldn't read player data " + this.player.getName() + " " + this.currentPlanet.getWorldName());
                return false;
            }
        }
        fileReader.close();
        return bl;
    }

    public boolean save() {
        boolean bl;
        File playerDataJson = FileUtils.getPlayerDataJson(this.currentPlanet, this.player);
        if (playerDataJson == null) {
            return false;
        }
        FileWriter writer = new FileWriter(playerDataJson);
        try {
            JSONObject playerObject = new JSONObject();
            JSONArray purchasesJson = new JSONArray();
            purchasesJson.addAll(this.purchases);
            playerObject.put((Object)"purchases", (Object)purchasesJson);
            JSONArray savedInventoryJson = this.serializeItems(this.savedInventory);
            playerObject.put((Object)"saved-inventory", (Object)savedInventoryJson);
            JSONArray enderChestJson = this.serializeItems(this.savedEnderChest);
            playerObject.put((Object)"saved-ender-chest", (Object)enderChestJson);
            writer.write(playerObject.toString());
            writer.close();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ErrorUtils.sendCriticalErrorMessage("Couldn't save player data " + this.player.getName() + " " + this.currentPlanet.getWorldName(), e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    private JSONArray serializeItems(ItemStack[] items) throws IOException {
        JSONArray json = new JSONArray();
        if (items == null) {
            return json;
        }
        for (ItemStack item : items) {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 BukkitObjectOutputStream dataOut = new BukkitObjectOutputStream((OutputStream)out);){
                dataOut.writeObject((Object)item);
                json.add((Object)Base64Coder.encodeLines((byte[])out.toByteArray()));
            }
        }
        return json;
    }

    public Set<String> getPurchases() {
        return this.purchases;
    }

    public void addPurchase(String id) {
        this.purchases.add(id);
    }

    public int hashCode() {
        return this.player.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPlanet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/planets/PlanetPlayer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/planets/PlanetPlayer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPlanet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

