/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetPlayer;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public class PlanetPlayers {
    private final Planet planet;
    private final Set<PlanetPlayer> planetPlayers = new HashSet<PlanetPlayer>();
    private final Set<String> buildersTrusted = new HashSet<String>();
    private final Set<String> buildersNotTrusted = new HashSet<String>();
    private final Set<String> developersTrusted = new HashSet<String>();
    private final Set<String> developersNotTrusted = new HashSet<String>();
    private final Set<String> developersGuests = new HashSet<String>();
    private final Set<String> bannedPlayers = new HashSet<String>();
    private final Set<String> whitelistedPlayers = new HashSet<String>();

    public PlanetPlayers(Planet planet) {
        this.planet = planet;
    }

    public void registerPlayer(@NotNull Player player) {
        if (player == null) {
            PlanetPlayers.$$$reportNull$$$0(0);
        }
        this.planetPlayers.add(new PlanetPlayer(this.planet, player));
    }

    public void unregisterPlayer(Player player) {
        this.planetPlayers.removeIf(planetPlayer -> planetPlayer.getPlayer().equals((Object)player));
        this.planet.getDevPlanet().getLastLocations().remove(player);
        this.planet.getDevPlanet().clearMarkedExecutors(player);
        this.planet.getLimits().clearPlayerLimits(player);
    }

    public PlanetPlayer getPlanetPlayer(Player player) {
        for (PlanetPlayer planetPlayer : this.planetPlayers) {
            if (!planetPlayer.getPlayer().equals((Object)player)) continue;
            return planetPlayer;
        }
        return null;
    }

    public void clear() {
        this.buildersTrusted.clear();
        this.developersTrusted.clear();
        this.buildersNotTrusted.clear();
        this.developersNotTrusted.clear();
        this.developersGuests.clear();
        this.bannedPlayers.clear();
        this.whitelistedPlayers.clear();
    }

    public void loadPlayers() {
        this.clear();
        FileConfiguration config = FileUtils.getPlanetConfig(this.planet);
        this.buildersTrusted.addAll(config.getStringList("players.builders.trusted"));
        this.developersTrusted.addAll(config.getStringList("players.developers.trusted"));
        this.buildersNotTrusted.addAll(config.getStringList("players.builders.not-trusted"));
        this.developersNotTrusted.addAll(config.getStringList("players.developers.not-trusted"));
        this.developersGuests.addAll(config.getStringList("players.developers.guests"));
        this.bannedPlayers.addAll(config.getStringList("players.blacklist"));
        this.whitelistedPlayers.addAll(config.getStringList("players.whitelist"));
    }

    public Set<String> getAllBuilders() {
        HashSet<String> builders = new HashSet<String>(this.getBuildersTrusted());
        builders.addAll(this.getBuildersNotTrusted());
        return builders;
    }

    public Set<String> getAllDevelopers() {
        HashSet<String> developers = new HashSet<String>(this.getDevelopersTrusted());
        developers.addAll(this.getDevelopersNotTrusted());
        developers.addAll(this.getDevelopersGuests());
        return developers;
    }

    public boolean isTrustedDeveloper(Player player) {
        if (this.planet.isOwner(player)) {
            return true;
        }
        if (player.hasPermission("opencreative.world.dev.others")) {
            return true;
        }
        for (String nickname : this.getDevelopersTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isNotTrustedDeveloper(Player player) {
        for (String nickname : this.getDevelopersNotTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isNotTrustedBuilder(Player player) {
        for (String nickname : this.getBuildersNotTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isTrustedBuilder(Player player) {
        if (this.planet.isOwner(player)) {
            return true;
        }
        if (player.hasPermission("opencreative.world.build.others")) {
            return true;
        }
        for (String nickname : this.getBuildersTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDeveloperGuest(Player player) {
        for (String nickname : this.getDevelopersGuests()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean canDevelop(Player player) {
        if (this.planet.isOwner(player)) {
            return true;
        }
        if (player.hasPermission("opencreative.world.dev.others")) {
            return true;
        }
        for (String nickname : this.getDevelopersTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        Player owner = Bukkit.getPlayer((String)this.planet.getOwner());
        if (owner == null) {
            return false;
        }
        if (!this.planet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(owner))) {
            return false;
        }
        for (String nickname : this.getDevelopersNotTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean canBuild(Player player) {
        if (this.planet.isOwner(player)) {
            return true;
        }
        if (player.hasPermission("opencreative.world.build.others")) {
            return true;
        }
        for (String nickname : this.getBuildersTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        Player owner = Bukkit.getPlayer((String)this.planet.getOwner());
        if (owner == null) {
            return false;
        }
        if (!this.planet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(owner))) {
            return false;
        }
        for (String nickname : this.getBuildersNotTrusted()) {
            if (!nickname.equalsIgnoreCase(player.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeBuilder(String nickname) {
        Planet playerPlanet;
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) && player.getGameMode() == GameMode.CREATIVE) {
            player.setGameMode(GameMode.ADVENTURE);
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        this.buildersNotTrusted.removeIf(builder -> builder.equalsIgnoreCase(nickname));
        this.buildersTrusted.removeIf(builder -> builder.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.not-trusted", this.buildersNotTrusted);
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.trusted", this.buildersTrusted);
    }

    public void removeDeveloper(String nickname) {
        Planet playerPlanet;
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                player.setGameMode(GameMode.ADVENTURE);
            }
            if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
                PlayerUtils.clearPlayer(player);
                player.teleport(this.planet.getTerritory().getWorld().getSpawnLocation());
            }
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        this.developersNotTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
        this.developersTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.not-trusted", this.developersNotTrusted);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.trusted", this.developersTrusted);
    }

    public void addDeveloperGuest(String nickname) {
        Planet playerPlanet;
        if (this.getAllDevelopers().size() > this.planet.getLimits().getDevelopersLimit()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.player-guest").replace("%player%", player.getName()));
            Sounds.WORLD_NOW_DEVELOPER_GUEST.play((Audience)player);
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        this.developersGuests.add(nickname);
        this.developersNotTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
        this.developersTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.guests", this.developersGuests);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.not-trusted", this.developersNotTrusted);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.trusted", this.developersTrusted);
    }

    public void addDeveloper(String nickname, boolean trusted) {
        Planet playerPlanet;
        if (this.getAllDevelopers().size() > this.planet.getLimits().getDevelopersLimit()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) && !trusted) {
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.player").replace("%player%", player.getName()));
            Sounds.WORLD_NOW_DEVELOPER.play((Audience)player);
            if (OpenCreative.getPlanetsManager().getDevPlanet(player) != null) {
                player.setGameMode(GameMode.CREATIVE);
            }
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        if (trusted) {
            this.developersNotTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
            this.developersTrusted.add(nickname);
        } else {
            this.developersTrusted.removeIf(developer -> developer.equalsIgnoreCase(nickname));
            this.developersNotTrusted.add(nickname);
        }
        this.developersGuests.removeIf(developer -> developer.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.guests", this.developersGuests);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.not-trusted", this.developersNotTrusted);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.trusted", this.developersTrusted);
    }

    public void addBuilder(String nickname, boolean trusted) {
        Planet playerPlanet;
        if (this.getAllBuilders().size() > this.planet.getLimits().getBuildersLimit()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player)) && !trusted) {
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.player").replace("%player%", player.getName()));
            Sounds.WORLD_NOW_BUILDER.play((Audience)player);
            if (OpenCreative.getPlanetsManager().getDevPlanet(player) == null) {
                player.setGameMode(GameMode.CREATIVE);
            }
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        if (trusted) {
            this.buildersNotTrusted.removeIf(builder -> builder.equalsIgnoreCase(nickname));
            this.buildersTrusted.add(nickname);
        } else {
            this.buildersTrusted.removeIf(builder -> builder.equalsIgnoreCase(nickname));
            this.buildersNotTrusted.add(nickname);
        }
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.not-trusted", this.buildersNotTrusted);
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.trusted", this.buildersTrusted);
        if (!this.planet.isLoaded()) {
            this.clear();
        }
    }

    public void unbanPlayer(String nickname) {
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        this.bannedPlayers.removeIf(ban -> ban.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.blacklist", this.bannedPlayers);
        if (!this.planet.isLoaded()) {
            this.clear();
        }
    }

    public void removeFromWhitelist(String nickname) {
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        this.whitelistedPlayers.removeIf(whitelisted -> whitelisted.equalsIgnoreCase(nickname));
        FileUtils.setPlanetConfigParameter(this.planet, "players.whitelist", this.whitelistedPlayers);
        if (!this.planet.isLoaded()) {
            this.clear();
        }
    }

    public void banPlayer(String nickname) {
        Planet playerPlanet;
        if (this.planet.isOwner(nickname)) {
            return;
        }
        if (this.getBannedPlayers().size() > this.planet.getLimits().getBlacklistedLimit()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && !player.hasPermission("opencreative.world.ban.bypass") && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
            PlayerUtils.teleportToLobby(player);
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.black-list.player").replace("%player%", player.getName()));
            Sounds.WORLD_BANNED.play((Audience)player);
            this.bannedPlayers.add(player.getName());
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        FileUtils.setPlanetConfigParameter(this.planet, "players.blacklist", this.bannedPlayers);
        if (!this.planet.isLoaded()) {
            this.clear();
        }
    }

    public void whitelistPlayer(String nickname) {
        Planet playerPlanet;
        if (this.planet.isOwner(nickname)) {
            return;
        }
        if (this.getWhitelistedPlayers().size() > this.planet.getLimits().getWhitelistedLimit()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && this.planet.equals(playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.white-list.player").replace("%player%", player.getName()));
            Sounds.WORLD_WHITELIST_ADDED.play((Audience)player);
            this.whitelistedPlayers.add(player.getName());
        }
        if (!this.planet.isLoaded()) {
            this.loadPlayers();
        }
        FileUtils.setPlanetConfigParameter(this.planet, "players.whitelist", this.whitelistedPlayers);
        if (!this.planet.isLoaded()) {
            this.clear();
        }
    }

    public void kickPlayer(Player player) {
        Planet playerPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (this.planet.equals(playerPlanet) && !player.hasPermission("opencreative.world.kick.bypass")) {
            PlayerUtils.teleportToLobby(player);
            player.sendMessage(MessageUtils.getLocaleMessage("world.players.kick.player").replace("%player%", player.getName()));
            Sounds.WORLD_KICKED.play((Audience)player);
        }
    }

    public Set<String> getAllPlayersFromConfig() {
        HashSet<String> allPlayers = new HashSet<String>();
        this.planet.getPlayers().forEach(player -> allPlayers.add(player.getName()));
        allPlayers.addAll(this.getBuildersTrusted());
        allPlayers.addAll(this.getBuildersNotTrusted());
        allPlayers.addAll(this.getDevelopersTrusted());
        allPlayers.addAll(this.getDevelopersNotTrusted());
        allPlayers.addAll(this.getDevelopersGuests());
        allPlayers.addAll(this.getBannedPlayers());
        allPlayers.addAll(this.getWhitelistedPlayers());
        allPlayers.remove(this.planet.getOwner());
        return allPlayers;
    }

    public Set<String> getBuildersTrusted() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.builders.trusted"));
        }
        return new HashSet<String>(this.buildersTrusted);
    }

    public Set<String> getBuildersNotTrusted() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.builders.not-trusted"));
        }
        return new HashSet<String>(this.buildersNotTrusted);
    }

    public Set<String> getDevelopersGuests() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.developers.guests"));
        }
        return new HashSet<String>(this.developersGuests);
    }

    public Set<String> getDevelopersTrusted() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.developers.trusted"));
        }
        return new HashSet<String>(this.developersTrusted);
    }

    public Set<String> getDevelopersNotTrusted() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.developers.not-trusted"));
        }
        return new HashSet<String>(this.developersNotTrusted);
    }

    public String getBuilders() {
        return String.join((CharSequence)", ", this.planet.getWorldPlayers().getAllBuilders());
    }

    public String getDevelopers() {
        return String.join((CharSequence)", ", this.planet.getWorldPlayers().getAllDevelopers());
    }

    public boolean isBanned(String nickname) {
        for (String banned : this.getBannedPlayers()) {
            if (!banned.equalsIgnoreCase(nickname)) continue;
            return true;
        }
        return false;
    }

    public boolean isWhitelisted(String nickname) {
        for (String whitelisted : this.getWhitelistedPlayers()) {
            if (!whitelisted.equalsIgnoreCase(nickname)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getBannedPlayers() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.blacklist"));
        }
        return this.bannedPlayers;
    }

    public Set<String> getWhitelistedPlayers() {
        if (!this.planet.isLoaded()) {
            return new HashSet<String>(FileUtils.getPlanetConfig(this.planet).getStringList("players.whitelist"));
        }
        return this.whitelistedPlayers;
    }

    public void purgeData() {
        ArrayList<String> empty = new ArrayList<String>();
        this.clear();
        FileUtils.setPlanetConfigParameter(this.planet, "players.unique", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.liked", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.disliked", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.blacklist", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.whitelist", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.trusted", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.not-trusted", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.developers.guests", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.trusted", empty);
        FileUtils.setPlanetConfigParameter(this.planet, "players.builders.not-trusted", empty);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "player", "ua/mcchickenstudio/opencreative/planets/PlanetPlayers", "registerPlayer"));
    }
}

