/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.settings;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public record Command(String commandLine, boolean console, long delay) {
    public void execute(final Player player, final Map<String, Object> placeholders) {
        if (this.delay > 0L) {
            new BukkitRunnable(){

                public void run() {
                    Command.this.dispatch(player, placeholders);
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), this.delay);
        } else {
            this.dispatch(player, placeholders);
        }
    }

    private void dispatch(Player player, Map<String, Object> placeholders) {
        String dispatchedCommand = this.commandLine;
        for (String placeholder : placeholders.keySet()) {
            dispatchedCommand = dispatchedCommand.replace(placeholder, placeholders.get(placeholder).toString());
        }
        if (player != null) {
            dispatchedCommand = MessageUtils.parsePAPI((OfflinePlayer)player, dispatchedCommand);
        }
        if (this.console) {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)dispatchedCommand);
        } else if (player != null) {
            player.performCommand(dispatchedCommand);
        }
    }
}

