/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.settings;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.settings.Command;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class Commands {
    private final Map<String, Command> onLobbyCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onPlanetConnectCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onPlanetDisconnectCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onWorldChatCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onCreativeChatCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onMaintenanceStartCommands = new LinkedHashMap<String, Command>();
    private final Map<String, Command> onMaintenanceEndCommands = new LinkedHashMap<String, Command>();

    public void load() {
        this.onLobbyCommands.clear();
        this.onPlanetConnectCommands.clear();
        this.onPlanetDisconnectCommands.clear();
        this.onWorldChatCommands.clear();
        this.onCreativeChatCommands.clear();
        this.onMaintenanceStartCommands.clear();
        this.onMaintenanceEndCommands.clear();
        FileConfiguration config = OpenCreative.getPlugin().getConfig();
        ConfigurationSection allCommandsSection = config.getConfigurationSection("commands");
        if (allCommandsSection == null) {
            return;
        }
        for (String eventName : allCommandsSection.getKeys(false)) {
            Map<String, Command> commandMap = this.getMap(eventName);
            if (commandMap == null) {
                ErrorUtils.sendWarningErrorMessage("Unknown event in commands section from config.yml: " + eventName);
                continue;
            }
            ConfigurationSection eventCommandsSection = allCommandsSection.getConfigurationSection(eventName);
            if (eventCommandsSection == null) continue;
            for (String commandName : eventCommandsSection.getKeys(false)) {
                String command = eventCommandsSection.getString(commandName + ".command");
                if (command == null || command.isEmpty()) continue;
                boolean console = eventCommandsSection.getBoolean(commandName + ".console", true);
                long delay = eventCommandsSection.getLong(commandName + ".delay", 0L);
                commandMap.put(commandName, new Command(command, console, delay));
            }
        }
        if (!this.onLobbyCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onLobbyCommands.size() + " commands for onSpawn");
        }
        if (!this.onPlanetConnectCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onPlanetConnectCommands.size() + " commands for onPlanetConnect");
        }
        if (!this.onPlanetDisconnectCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onPlanetDisconnectCommands.size() + " commands for onPlanetDisconnect");
        }
        if (!this.onWorldChatCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onWorldChatCommands.size() + " commands for onWorldChat");
        }
        if (!this.onCreativeChatCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onCreativeChatCommands.size() + " commands for onCreativeChat");
        }
        if (!this.onMaintenanceStartCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onMaintenanceStartCommands.size() + " commands for onMaintenanceStart");
        }
        if (!this.onMaintenanceEndCommands.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Registered " + this.onMaintenanceEndCommands.size() + " commands for onMaintenanceEnd");
        }
    }

    private Map<String, Command> getMap(String eventName) {
        return switch (eventName) {
            case "onLobby" -> this.onLobbyCommands;
            case "onPlanetConnect" -> this.onPlanetConnectCommands;
            case "onPlanetDisconnect" -> this.onPlanetDisconnectCommands;
            case "onWorldChat" -> this.onWorldChatCommands;
            case "onCreativeChat" -> this.onCreativeChatCommands;
            case "onMaintenanceStart" -> this.onMaintenanceStartCommands;
            case "onMaintenanceEnd" -> this.onMaintenanceEndCommands;
            default -> null;
        };
    }

    public void execute(Player player, String eventName, Map<String, Object> placeholders) {
        Map<String, Command> map = this.getMap(eventName);
        if (map == null) {
            return;
        }
        for (String commandName : map.keySet()) {
            Command command = map.get(commandName);
            command.execute(player, placeholders);
        }
    }
}

