/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import ua.mcchickenstudio.opencreative.OpenCreative;

public class Advancement {
    private final Material material;
    private final AdvancementStyle advancementStyle;
    private final String title;
    private final String message;
    private final NamespacedKey nameSpacedKey = new NamespacedKey((Plugin)OpenCreative.getPlugin(), UUID.randomUUID().toString());

    private Advancement(ItemStack itemStack, AdvancementStyle style, String title, String message) {
        this.material = itemStack.getType();
        this.advancementStyle = style;
        this.title = title;
        this.message = message;
    }

    public static Advancement make(ItemStack itemStack, AdvancementStyle style, String title, String message) {
        return new Advancement(itemStack, style, title, message);
    }

    public void show(Player player) {
        this.load();
        player.getAdvancementProgress(Bukkit.getAdvancement((NamespacedKey)this.nameSpacedKey)).awardCriteria("trigger");
        Bukkit.getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> player.getAdvancementProgress(Bukkit.getAdvancement((NamespacedKey)this.nameSpacedKey)).revokeCriteria("trigger"), 10L);
    }

    private void load() {
        Bukkit.getUnsafe().loadAdvancement(this.nameSpacedKey, "{\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"id\": \"minecraft:" + this.material.toString().toLowerCase() + "\"\n        },\n        \"title\": {\n            \"text\": \"" + this.title + "\n" + this.message + "\"\n        },\n        \"description\": {\n            \"text\": \"\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"" + this.advancementStyle.toString().toLowerCase() + "\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"requirements\": [\n        [\n            \"trigger\"\n        ]\n    ]\n}");
    }

    public static enum AdvancementStyle {
        GOAL,
        TASK,
        CHALLENGE;

    }
}

