/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

public class ColorUtils {
    public static int[] parseRGB(String string) {
        int[] rgbColor = new int[]{255, 255, 255};
        try {
            String[] colorString = new String[3];
            boolean isHexCode = false;
            if (string.contains(", ")) {
                colorString = string.split(", ");
            } else if (string.contains(",")) {
                colorString = string.split(",");
            } else if (string.contains(" ")) {
                colorString = string.split(" ");
            } else if (string.startsWith("#") && string.length() == 7) {
                colorString[0] = string.substring(1, 3);
                colorString[1] = string.substring(3, 5);
                colorString[2] = string.substring(5, 7);
                isHexCode = true;
            } else if (string.length() == 6) {
                colorString[0] = string.substring(0, 2);
                colorString[1] = string.substring(2, 4);
                colorString[2] = string.substring(4, 6);
                isHexCode = true;
            }
            if (colorString.length == 3) {
                int blue;
                int red = isHexCode ? Integer.valueOf(colorString[0], 16) : Integer.parseInt(colorString[0]);
                int green = isHexCode ? Integer.valueOf(colorString[1], 16) : Integer.parseInt(colorString[1]);
                int n = blue = isHexCode ? Integer.valueOf(colorString[2], 16) : Integer.parseInt(colorString[2]);
                if (red >= 0 && red <= 255 && green >= 0 && green <= 255 && blue >= 0 && blue <= 255) {
                    rgbColor[0] = red;
                    rgbColor[1] = green;
                    rgbColor[2] = blue;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rgbColor;
    }
}

