/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.util.HashMap;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.settings.groups.Group;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class CooldownUtils {
    static final HashMap<Player, Long> genericCommandCooldown = new HashMap();
    static final HashMap<Player, Long> advertisementCommandCooldown = new HashMap();
    static final HashMap<Player, Long> creativeChatCooldown = new HashMap();
    static final HashMap<Player, Long> worldChatCooldown = new HashMap();
    static final HashMap<Player, Long> modulesManipulationsCooldown = new HashMap();
    static final HashMap<Player, Long> blocksDuplicationCooldown = new HashMap();

    public static long getCooldownFromMap(Player player, CooldownType type) {
        HashMap<Player, Long> cooldownMap = CooldownUtils.getCooldownMap(type);
        if (!cooldownMap.containsKey(player)) {
            return 0L;
        }
        return cooldownMap.get(player);
    }

    public static void setCooldown(Player player, int cooldown, CooldownType type) {
        long cooldownInMillis = (long)cooldown * 1000L;
        long currentTime = System.currentTimeMillis();
        long cooldownEndTime = currentTime + cooldownInMillis;
        HashMap<Player, Long> cooldownMap = CooldownUtils.getCooldownMap(type);
        cooldownMap.put(player, cooldownEndTime);
    }

    public static int getCooldown(Player player, CooldownType type) {
        if (player.hasPermission("opencreative.cooldown.bypass")) {
            return 0;
        }
        long cooldownEndTime = CooldownUtils.getCooldownFromMap(player, type);
        if (cooldownEndTime == 0L) {
            return 0;
        }
        long currentTime = System.currentTimeMillis();
        if (cooldownEndTime < currentTime) {
            return 0;
        }
        return Math.round(cooldownEndTime - currentTime) / 1000;
    }

    public static boolean checkAndSetCooldown(Player player, Group group, CooldownType type) {
        int currentCooldown = CooldownUtils.getCooldown(player, type);
        if (currentCooldown > 0) {
            return false;
        }
        CooldownUtils.setCooldown(player, CooldownUtils.getGroupCooldown(type, group), type);
        return true;
    }

    public static boolean checkAndSetCooldownWithMessage(Player player, Group group, CooldownType type) {
        if (!CooldownUtils.checkAndSetCooldown(player, group, type)) {
            player.sendMessage(MessageUtils.getLocaleMessage("cooldown").replace("%cooldown%", String.valueOf(CooldownUtils.getCooldown(player, type))));
            return false;
        }
        return true;
    }

    public static boolean checkAndSetCooldownWithMessage(Player player, CooldownType type) {
        Group group = OpenCreative.getSettings().getGroups().getGroup(player);
        return CooldownUtils.checkAndSetCooldownWithMessage(player, group, type);
    }

    public static void clearPlayerCooldowns(Player player) {
        genericCommandCooldown.remove(player);
        advertisementCommandCooldown.remove(player);
        creativeChatCooldown.remove(player);
        worldChatCooldown.remove(player);
        modulesManipulationsCooldown.remove(player);
        blocksDuplicationCooldown.remove(player);
    }

    private static HashMap<Player, Long> getCooldownMap(CooldownType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> genericCommandCooldown;
            case 1 -> advertisementCommandCooldown;
            case 2 -> creativeChatCooldown;
            case 3 -> worldChatCooldown;
            case 4 -> modulesManipulationsCooldown;
            case 5 -> blocksDuplicationCooldown;
        };
    }

    private static int getGroupCooldown(CooldownType type, Group group) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> group.getGenericCommandCooldown();
            case 1 -> group.getAdvertisementCooldown();
            case 2 -> group.getCreativeChatCooldown();
            case 3 -> group.getChatCooldown();
            case 4 -> group.getModuleManipulationCooldown();
            case 5 -> group.getBlocksDuplicationCooldown();
        };
    }

    public static enum CooldownType {
        GENERIC_COMMAND,
        ADVERTISEMENT_COMMAND,
        CREATIVE_CHAT,
        WORLD_CHAT,
        MODULE_MANIPULATION,
        BLOCKS_DUPLICATION;

    }
}

