/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Argument;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.conditions.Condition;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.values.EventValue;
import ua.mcchickenstudio.opencreative.coding.values.EventValues;
import ua.mcchickenstudio.opencreative.events.planet.PlanetModeChangeEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ErrorUtils {
    private static String cutClassesName(String text) {
        String newText = text == null ? "Error message is not available" : text;
        newText = newText.replace("ua.mcchickenstudio.opencreative.coding.", "");
        newText = newText.replace("ua.mcchickenstudio.opencreative.", "");
        newText = newText.replace("org.bukkit.", "");
        newText = newText.replace("io.papermc.", "");
        newText = newText.replace("com.destroystokyo.", "");
        newText = newText.replace("java.lang.", "java.");
        newText = newText.replace("blocks.", "");
        return newText;
    }

    public static String parseException(Exception error, boolean colored) {
        HashSet<CallSite> lastStacks = new HashSet<CallSite>();
        int i = 0;
        for (StackTraceElement stackTraceElement : error.getStackTrace()) {
            Object stack = stackTraceElement.getClassName() + ":" + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber();
            stack = ErrorUtils.cutClassesName((String)stack);
            lastStacks.add((CallSite)((Object)((colored ? "\u00a7c" : "") + (String)stack)));
            i = (byte)(i + 1);
            if (i == 15) break;
        }
        return "\n" + (colored ? "\u00a7c" : "") + "\u2639 Exception has occurred...\n" + (String)(!colored ? "\\|/ _____ \\|/\n\"@'/ . . \\`@\" " + OpenCreative.getVersion() + "\n/_| \\___/ |_\\ " + ErrorUtils.getRandomPhrase() + "\n   \\___U_/\n" : "") + (colored ? "\u00a74 " : " ") + error.getClass().getSimpleName() + ": " + ErrorUtils.cutClassesName(error.getMessage()) + "\n \n" + String.join((CharSequence)"\n", lastStacks);
    }

    private static String getRandomPhrase() {
        String[] phrases = new String[]{"Things aren't so different..", "Seems like we messed up..", "We never gonna give console up..", "We'll meet again, some sunny day..", "We're fine, We won't lose our mind..", "Oops!", "Kernel Panic.. are we kernel?", "We'll see.. if you will report it.", "It is fine..", "I don't like errors, okay?", "At least not memory leak, yes?", "Don't be mad, be happy that something works.", "Totally OpenCreative+.", "My final message - goodbye!", "And here's we hanging out.", "This plugin ate a sparc! Gah!", "I blame PEOPLE BELOW for this.", "Well, it's possible. <-- (our catchphrase)", "Bug after bug, after bug, it never ends.", "I'll get out of this problem tonight.", "Try not to think about how long bug was here.", "You'll get one bug instead of zero.", "Totally powered by Java.", "Totally Minecraft plugin.", "Can someone just show me the fix?", "Errors in the plugin that never ends", "It might just work if we can try not to go insane", "Try not to panic when you see this", "This is not supposed to be here", ":( Your PLUGIN ran into a problem.", "Why is this happening?", "Dum dum, this sucks..", "Error the Troublemaker..", "Knocks off worlds like a terminator", "Gotta hate it cause' you just can't like it", "We had something to learn from that experience"};
        return phrases[new Random().nextInt(phrases.length)];
    }

    public static void sendPlayerErrorMessage(Player player, String errorMessage) {
        OpenCreative.getPlugin().getLogger().warning("An player error has occurred for " + player.getName() + ": " + errorMessage);
        player.sendMessage(MessageUtils.getLocaleMessage("player-error").replace("%error%", errorMessage));
        Sounds.PLAYER_ERROR.play((Audience)player);
    }

    public static void sendPlayerErrorMessage(Player player, String errorMessage, Exception error) {
        if (OpenCreative.getSettings().isConsoleWarnings()) {
            OpenCreative.getPlugin().getLogger().warning("An player error has occurred for " + player.getName() + ": " + errorMessage + " " + ErrorUtils.parseException(error, false));
        }
        Component message = Component.text((String)MessageUtils.getLocaleMessage("player-error").replace("%error%", errorMessage)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)ErrorUtils.parseException(error, true))));
        player.sendMessage(message);
        Sounds.PLAYER_ERROR.play((Audience)player);
    }

    public static void sendPlanetErrorMessage(Planet planet, String errorMessage) {
        if (OpenCreative.getSettings().isConsoleWarnings()) {
            OpenCreative.getPlugin().getLogger().warning("An error has occurred in planet " + planet.getWorldName() + ": " + errorMessage);
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(MessageUtils.getLocaleMessage("planet-error").replace("%error%", errorMessage));
            Sounds.PLAYER_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetErrorMessage(Planet planet, String errorMessage, Exception error) {
        if (OpenCreative.getSettings().isConsoleWarnings()) {
            OpenCreative.getPlugin().getLogger().warning("An error has occurred in planet " + planet.getWorldName() + ": " + errorMessage + " " + ErrorUtils.parseException(error, false));
        }
        for (Player player : planet.getPlayers()) {
            Component message = Component.text((String)MessageUtils.getLocaleMessage("planet-error").replace("%error%", errorMessage)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)ErrorUtils.parseException(error, true))));
            player.sendMessage(message);
            Sounds.PLAYER_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCodeWarningMessage(Executor executor, Action action, String warningMessage) {
        Planet planet = executor.getPlanet();
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            Component message = ((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("planet-code-warning.message").replace("%event%", executor.getExecutorType().getLocaleName()).replace("%action%", action.getActionType().getLocaleName()).replace("%warning%", warningMessage).replace("%x%", String.valueOf(action.getX())).replace("%y%", String.valueOf(executor.getY())).replace("%z%", String.valueOf(executor.getZ()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message"))))).clickEvent(ClickEvent.runCommand((String)("/dev " + action.getX() + " " + executor.getY() + " " + executor.getZ())));
            player.sendMessage(message);
            Sounds.WORLD_CODE_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCodeErrorMessage(Executor executor, Action action, String errorMessage, Exception error) {
        Planet planet = executor.getPlanet();
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            Component message = ((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("coding-error.message").replace("%event%", executor.getExecutorType().getLocaleName()).replace("%action%", action.getActionType().getLocaleName()).replace("%error%", errorMessage).replace("%x%", String.valueOf(action.getX())).replace("%y%", String.valueOf(action.getExecutor().getY())).replace("%z%", String.valueOf(action.getExecutor().getZ()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message") + "\n" + ErrorUtils.parseException(error, true))))).clickEvent(ClickEvent.runCommand((String)("/dev " + ((double)action.getX() - 0.5) + " " + action.getExecutor().getY() + " " + ((double)action.getExecutor().getZ() - 0.5))));
            player.sendMessage(message);
            Sounds.WORLD_CODE_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCodeErrorMessage(Executor executor, Action action, Entity entity, String errorMessage) {
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByWorld(entity.getWorld());
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(MessageUtils.getLocaleMessage("coding-error.message").replace("%event%", executor.getExecutorType().getLocaleName()).replace("%action%", action.getActionType().toString()).replace("%error%", errorMessage).replace("%x%", String.valueOf(action.getX())).replace("%y%", String.valueOf(executor.getY())).replace("%z%", String.valueOf(executor.getZ())));
            Sounds.WORLD_CODE_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCodeCriticalErrorMessage(Planet planet, Executor executor, String errorMessage) {
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            Sounds.WORLD_CODE_CRITICAL_ERROR.play((Audience)player);
            Component message = ((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("coding-error.message-event-critical").replace("%event%", executor.getExecutorType().getLocaleName()).replace("%error%", errorMessage).replace("%x%", String.valueOf(executor.getX())).replace("%y%", String.valueOf(executor.getY())).replace("%z%", String.valueOf(executor.getZ()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message"))))).clickEvent(ClickEvent.runCommand((String)("/dev " + executor.getX() + " " + executor.getY() + " " + executor.getZ())));
            player.sendMessage(message);
        }
    }

    public static void sendPlanetCodeErrorMessage(Planet planet, Executor executor, String errorMessage) {
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            Component message = ((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("coding-error.message-event").replace("%event%", executor.getExecutorType().getLocaleName()).replace("%error%", errorMessage).replace("%x%", String.valueOf(executor.getX())).replace("%y%", String.valueOf(executor.getY())).replace("%z%", String.valueOf(executor.getZ()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message"))))).clickEvent(ClickEvent.runCommand((String)("/dev " + executor.getX() + " " + executor.getY() + " " + executor.getZ())));
            player.sendMessage(message);
            Sounds.WORLD_CODE_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCompileErrorMessage(Planet planet, Block block, String errorMessage) {
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            Component message = ((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("coding-error.message-compile").replace("%error%", errorMessage).replace("%x%", String.valueOf(block.getX())).replace("%y%", String.valueOf(block.getY())).replace("%z%", String.valueOf(block.getZ()))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message"))))).clickEvent(ClickEvent.runCommand((String)("/dev " + block.getX() + " " + block.getY() + " " + block.getZ())));
            player.sendMessage(message);
            Sounds.WORLD_CODE_COMPILE_ERROR.play((Audience)player);
        }
    }

    public static void sendPlanetCompileErrorMessage(Planet planet, List<Block> unknownBlocks) {
        if (planet == null) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(MessageUtils.getLocaleMessage("coding-error.unknown-block-detected").replace("%error%", MessageUtils.getLocaleMessage("coding-error.unknown-blocks", false)));
            for (Block block : unknownBlocks) {
                NamedTextColor color = NamedTextColor.GRAY;
                String category = "???";
                String type = BlockUtils.getSignLine(block.getLocation(), 3);
                if (type == null || type.isEmpty()) {
                    type = "???";
                }
                ExecutorCategory executorCategory = ExecutorCategory.getByMaterial(block.getType());
                ActionCategory actionCategory = ActionCategory.getByMaterial(block.getType());
                if (executorCategory != null) {
                    color = executorCategory.getColor();
                    category = executorCategory.getLocaleName();
                } else if (actionCategory != null) {
                    color = actionCategory.getColor();
                    category = actionCategory.getLocaleName();
                }
                Component blockCoordinatesMessage = ((TextComponent)((TextComponent)Component.text((String)MessageUtils.getLocaleMessage("coding-error.unknown-block-coords").replace("%x%", String.valueOf(block.getLocation().getX())).replace("%y%", String.valueOf(block.getLocation().getY())).replace("%z%", String.valueOf(block.getLocation().getZ())).replace("%category%", category).replace("%type%", type)).color((TextColor)color)).hoverEvent((HoverEventSource)HoverEvent.showText((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("coding-error.hover-message"))))).clickEvent(ClickEvent.runCommand((String)("/dev " + block.getLocation().getX() + " " + block.getLocation().getY() + " " + block.getLocation().getZ())));
                player.sendMessage(blockCoordinatesMessage);
            }
            Sounds.WORLD_CODE_COMPILE_ERROR.play((Audience)player);
            player.sendMessage(" ");
        }
    }

    public static void stopPlanetCode(Planet planet) {
        OpenCreative.getPlugin().getLogger().info("Planet code has been stopped in " + planet.getWorldName() + " because of operations limit.");
        if (planet.getMode() != Planet.Mode.BUILD) {
            PlanetModeChangeEvent event = new PlanetModeChangeEvent(planet, planet.getMode(), Planet.Mode.BUILD);
            event.callEvent();
            if (!event.isCancelled()) {
                planet.setMode(Planet.Mode.BUILD);
            }
        }
    }

    public static void sendWarningErrorMessage(String errorMessage) {
        if (OpenCreative.getSettings().isConsoleWarnings()) {
            OpenCreative.getPlugin().getLogger().warning("Warning! An error has occured: " + errorMessage);
        }
    }

    public static void sendWarningMessage(String errorMessage, Exception error) {
        if (OpenCreative.getSettings().isConsoleWarnings()) {
            OpenCreative.getPlugin().getLogger().warning("Warning! " + errorMessage + " " + ErrorUtils.parseException(error, false));
        }
    }

    public static void sendCriticalErrorMessage(String errorMessage) {
        if (OpenCreative.getSettings().isConsoleCriticalErrors()) {
            OpenCreative.getPlugin().getLogger().severe("CRITICAL ERROR has occured: " + errorMessage);
        }
    }

    public static void sendCriticalErrorMessage(String errorMessage, Exception error) {
        if (OpenCreative.getSettings().isConsoleCriticalErrors()) {
            OpenCreative.getPlugin().getLogger().severe("CRITICAL ERROR has occurred: " + errorMessage + " " + ErrorUtils.parseException(error, false));
        }
    }

    public static void sendDebug(String message) {
        if (OpenCreative.getSettings().isDebug()) {
            OpenCreative.getPlugin().getLogger().info("[DEBUG] " + message);
        }
    }

    public static void sendDebugError(String errorMessage, Exception error) {
        if (OpenCreative.getSettings().isDebug()) {
            OpenCreative.getPlugin().getLogger().severe("CRITICAL ERROR has occurred: " + errorMessage + " " + ErrorUtils.parseException(error, false));
        }
    }

    public static void sendCodingDebugNotFoundVariable(Planet planet, String name) {
    }

    public static void sendCodingNotFoundEventValue(Planet planet, Executor executor, Class<? extends EventValue> clazz) {
        if (planet == null) {
            return;
        }
        EventValue eventValue = EventValues.getInstance().getByClass(clazz);
        ErrorUtils.sendPlanetCodeErrorMessage(planet, executor, MessageUtils.getLocaleMessage("coding-error.temp-var-not-exists", false).replace("%variable%", eventValue != null ? eventValue.getLocaleName() : clazz.getSimpleName()));
    }

    public static void sendCodingDebugLog(Planet planet, String log) {
        if (!planet.isDebug()) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(MessageUtils.getLocaleMessage("coding-debug.log", false).replace("%log%", log));
        }
    }

    public static void sendCodingDebugVariable(Planet planet, String name, Object value) {
    }

    public static void sendCodingDebugExecutor(Executor executor) {
        Planet planet = executor.getPlanet();
        if (planet == null || !planet.isDebug()) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(MessageUtils.getLocaleMessage("coding-debug.executor-message", false).replace("%type%", executor.getExecutorType().getLocaleName()).replace("%x%", String.valueOf(executor.getX())).replace("%y%", String.valueOf(executor.getY())).replace("%z%", String.valueOf(executor.getZ())));
        }
    }

    public static void sendCodingDebugAction(Action action) {
        if (action.getExecutor() == null) {
            return;
        }
        Planet planet = action.getExecutor().getPlanet();
        if (planet == null || !planet.isDebug()) {
            return;
        }
        List<Argument> arguments = action.getArgumentsList();
        String message = MessageUtils.getLocaleMessage("coding-debug.hover." + (action.getActionType().isCondition() ? "condition" : "action"));
        message = message.replace("%category%", action.getActionCategory().getLocaleName());
        message = message.replace("%type%", action.getActionType().getLocaleName());
        if (action instanceof Condition) {
            Condition condition = (Condition)action;
            message = message.replace("%opposed%", MessageUtils.getLocaleMessage("coding-debug.condition.opposed." + condition.isOpposed()));
        }
        ArrayList<String> argumentsString = new ArrayList<String>();
        for (Argument arg : arguments) {
            argumentsString.add(MessageUtils.getLocaleMessage("coding-debug.hover.argument").replace("%name%", arg.getPath()).replace("%type%", arg.getType().getLocaleName()).replace("%value%", arg.getValue(action).toString().substring(0, Math.min(30, arg.getValue(action).toString().length()))));
        }
        message = message.replace("%arguments%", String.join((CharSequence)" \n", argumentsString));
        String actionMessage = MessageUtils.getLocaleMessage("coding-debug.action-message", false).replace("%type%", action.getActionType().getLocaleName()).replace("%x%", String.valueOf(action.getX())).replace("%y%", String.valueOf(action.getExecutor().getY())).replace("%z%", String.valueOf(action.getExecutor().getZ()));
        for (Player player : planet.getPlayers()) {
            player.sendMessage(Component.text((String)actionMessage).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)message))));
        }
    }
}

