/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.indev.OfflineWander;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetInfo;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class FileUtils {
    public static void createWorldSettings(int id, Player owner, World.Environment environment, String generatorID) {
        File file;
        String worldFolderPath = FileUtils.getPlanetsStorageFolder().getPath() + File.separator + "planet" + id + File.separator;
        File folder = new File(worldFolderPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(file = new File(worldFolderPath, "settings.yml")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException error) {
                ErrorUtils.sendCriticalErrorMessage("Couldn't create a settings.yml for world " + id, error);
                return;
            }
        }
        YamlConfiguration worldFile = YamlConfiguration.loadConfiguration((File)file);
        FileUtils.fillDefaultSettings((FileConfiguration)worldFile, id, owner, environment, generatorID);
        try {
            worldFile.save(file);
        }
        catch (IOException | IllegalArgumentException error) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't save world settings.yml for " + id, error);
        }
    }

    public static void fillDefaultSettings(FileConfiguration config, int id, Player owner, World.Environment environment, String generatorID) {
        config.set("owner", (Object)owner.getName());
        config.set("owner-uuid", (Object)owner.getUniqueId().toString());
        config.set("owner-group", (Object)OpenCreative.getSettings().getGroups().getGroup(owner).getName().toLowerCase());
        config.set("environment", (Object)environment.name());
        config.set("generator", (Object)generatorID);
        config.set("world", (Object)("planet" + id));
        config.set("creation-time", (Object)System.currentTimeMillis());
        config.set("last-activity-time", (Object)System.currentTimeMillis());
        config.set("name", (Object)MessageUtils.getLocaleMessage("creating-world.default-world-name").replace("%player%", owner.getName()));
        config.set("description", (Object)MessageUtils.getLocaleMessage("creating-world.default-world-description").replace("%player%", owner.getName()));
        config.set("icon", (Object)String.valueOf(Material.DIAMOND));
        config.set("sharing", (Object)String.valueOf((Object)Planet.Sharing.PUBLIC));
        config.set("category", (Object)String.valueOf((Object)PlanetInfo.Category.SANDBOX));
        config.set("customID", (Object)String.valueOf(id));
        config.set("players.unique", new ArrayList());
        config.set("players.liked", new ArrayList());
        config.set("players.builders.trusted", new ArrayList());
        config.set("players.builders.not-trusted", new ArrayList());
        config.set("players.developers.trusted", new ArrayList());
        config.set("players.developers.not-trusted", new ArrayList());
        config.set("players.whitelist", new ArrayList());
        config.set("players.blacklist", new ArrayList());
        config.set("flags", new HashMap());
    }

    public static void createCodeScript(String path, String worldName) {
        File file = new File(path, "codeScript.yml");
        YamlConfiguration worldFile = YamlConfiguration.loadConfiguration((File)file);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException error) {
                ErrorUtils.sendCriticalErrorMessage("Couldn't create a codeScript.yml for planet " + FileUtils.getPlanetIdFromName(worldName) + " because of IOException. Maybe it is already exists? " + error.getMessage());
                return;
            }
        }
        worldFile.set("world", (Object)FileUtils.getPlanetIdFromName(worldName));
        worldFile.set("creation-time", (Object)System.currentTimeMillis());
        worldFile.set("last-activity-time", (Object)System.currentTimeMillis());
        worldFile.createSection("code");
        try {
            worldFile.save(file);
        }
        catch (IOException | IllegalArgumentException error) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't save world codeScript.yml for " + worldName + " because of " + error.getClass().getName() + " " + error.getMessage());
        }
    }

    public static void loadLocales() {
        OpenCreative.getPlugin().getLogger().info("Loading localization file...");
        File folder = new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator);
        if (!folder.exists() && !folder.mkdirs()) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't create directory for locales... " + folder.getPath());
        }
        String selectedLang = OpenCreative.getPlugin().getConfig().getString("messages.locale", "en");
        File file = new File(folder.getPath() + File.separator + selectedLang + ".yml");
        if (!file.exists()) {
            FileUtils.setDefaultLocales();
            OpenCreative.getPlugin().getConfig().set("messages.locale", (Object)"en");
        }
        MessageUtils.loadLocalizationFile();
        OpenCreative.getPlugin().getLogger().info("Loaded localization file...");
    }

    private static void setDefaultLocales() {
        try {
            OpenCreative.getPlugin().saveResource("locales" + File.separator + "ru.yml", false);
        }
        catch (IllegalArgumentException error) {
            ErrorUtils.sendWarningErrorMessage("Couldn't save default localization file (resource) " + error.getClass().getName() + " " + error.getMessage());
        }
        OpenCreative.getPlugin().saveConfig();
    }

    public static void resetLocales() {
        OpenCreative.getPlugin().getLogger().info("Resetting localization file...");
        File folder = new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator);
        if (!folder.exists() && !folder.mkdirs()) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't create directory for locales... " + folder.getPath());
        }
        String selectedLang = OpenCreative.getPlugin().getConfig().getString("messages.locale", "en");
        File file = new File(folder.getPath() + File.separator + selectedLang + ".yml");
        if (file.exists()) {
            file.delete();
        }
        FileUtils.setDefaultLocales();
        MessageUtils.loadLocalizationFile();
        OpenCreative.getPlugin().getLogger().info("Reset localization file!");
    }

    public static void loadPlanets() {
        OpenCreative.getPlugin().getLogger().info("Registering worlds to base...");
        try {
            FileUtils.convertOldPlanetFolders();
            File[] planetsFolders = FileUtils.getWorldsFolders();
            if (planetsFolders.length == 0) {
                OpenCreative.getPlugin().getLogger().info("No worlds have been detected.");
                return;
            }
            OpenCreative.getPlugin().getLogger().info("Found " + planetsFolders.length + " worlds, adding...");
            int corruptedWorlds = 0;
            int deprecatedWorlds = 0;
            long currentTime = System.currentTimeMillis();
            for (File planetFolder : planetsFolders) {
                OfflinePlayer planetOwner;
                String worldName = planetFolder.getPath().replace(String.valueOf(Bukkit.getServer().getWorldContainer()) + File.separator, "").replace("planets" + File.separator, "");
                if (worldName.endsWith("dev")) continue;
                OpenCreative.getPlugin().getLogger().info("Adding world " + worldName + " to base...");
                int id = -1;
                try {
                    id = Integer.parseInt(worldName.replace("planet", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (id == -1) continue;
                Planet planet = new Planet(id);
                if (planet.isCorrupted()) {
                    ++corruptedWorlds;
                    continue;
                }
                if (currentTime - planet.getCreationTime() <= 2592000000L || (planetOwner = Bukkit.getOfflinePlayer((String)planet.getOwner())).getLastSeen() != 0L && currentTime - planetOwner.getLastSeen() <= 2592000000L) continue;
                ++deprecatedWorlds;
            }
            OpenCreative.getPlugin().getLogger().info("Loaded " + OpenCreative.getPlanetsManager().getPlanets().size() + " worlds for " + (System.currentTimeMillis() - currentTime) + " ms.");
            OpenCreative.getPlugin().getLogger().info(" Deprecated worlds: " + deprecatedWorlds);
            OpenCreative.getPlugin().getLogger().info(" Corrupted worlds: " + corruptedWorlds);
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("An error has occurred while loading worlds...", error);
        }
    }

    public static void loadModules() {
        OpenCreative.getPlugin().getLogger().info("Registering modules to base...");
        try {
            File[] modulesList = FileUtils.getModulesStorageFolder().listFiles();
            if (modulesList == null) {
                OpenCreative.getPlugin().getLogger().info("No modules have been detected.");
                return;
            }
            OpenCreative.getPlugin().getLogger().info("Found " + modulesList.length + " modules, adding...");
            long currentTime = System.currentTimeMillis();
            for (File moduleFile : FileUtils.getModulesFiles()) {
                String moduleName = moduleFile.getPath().replace(String.valueOf(Bukkit.getServer().getWorldContainer()) + File.separator, "").replace("modules" + File.separator, "").replace(".yml", "");
                OpenCreative.getPlugin().getLogger().info("Adding module " + moduleName + " to base...");
                int id = -1;
                try {
                    id = Integer.parseInt(moduleName.replace("module", ""));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (id == -1) continue;
                Module module = new Module(id);
                OpenCreative.getModuleManager().registerModule(module);
            }
            OpenCreative.getPlugin().getLogger().info("Loaded " + OpenCreative.getModuleManager().getModules().size() + " modules for " + (System.currentTimeMillis() - currentTime) + " ms.");
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("An error has occurred while loading modules...", error);
        }
    }

    public static File getPlanetFolder(Planet planet) {
        return new File(FileUtils.getPlanetFolderPath(planet));
    }

    public static File getDevPlanetFolder(DevPlanet devPlanet) {
        return new File(devPlanet.getWorldName() + File.separator);
    }

    public static FileConfiguration getPlanetConfig(Planet planet) {
        File file = FileUtils.getPlanetConfigFile(planet);
        return YamlConfiguration.loadConfiguration((File)file);
    }

    public static File getPlanetConfigFile(Planet planet) {
        return new File(FileUtils.getPlanetFolder(planet), "settings.yml");
    }

    public static File getPlanetScriptFile(Planet planet) {
        File scriptFile = new File(FileUtils.getPlanetFolder(planet), "codeScript.yml");
        if (!scriptFile.exists()) {
            FileUtils.createCodeScript(FileUtils.getPlanetFolder(planet).getPath(), planet.getWorldName());
        }
        return scriptFile;
    }

    public static File getPlanetVariablesJson(Planet planet) {
        File variablesFile = new File(FileUtils.getPlanetFolder(planet), "variables.json");
        if (!variablesFile.exists()) {
            try {
                variablesFile.createNewFile();
            }
            catch (Exception error) {
                ErrorUtils.sendCriticalErrorMessage("Failed to create world's variables file.", error);
                return null;
            }
        }
        return variablesFile;
    }

    @Nullable
    public static File getWanderJsonFile(@NotNull OfflineWander wander, boolean create) {
        File wanderFile;
        File wandersFolder;
        if (wander == null) {
            FileUtils.$$$reportNull$$$0(0);
        }
        if (!(wandersFolder = FileUtils.getWandersStorageFolder()).exists()) {
            wandersFolder.mkdirs();
        }
        if (!(wanderFile = new File(FileUtils.getWandersStorageFolder(), String.valueOf(wander.getUniqueId()) + ".json")).exists()) {
            if (!create) {
                return null;
            }
            try {
                if (!wanderFile.createNewFile()) {
                    ErrorUtils.sendDebug("Cannot create new wander's file: " + String.valueOf(wanderFile));
                }
            }
            catch (Exception error) {
                ErrorUtils.sendCriticalErrorMessage("Failed to create new wander's file: " + String.valueOf(wanderFile), error);
                return null;
            }
        }
        return wanderFile;
    }

    public static File getPlayerDataJson(Planet planet, Player player) {
        File planetFolder = FileUtils.getPlanetFolder(planet);
        File folder = new File(planetFolder.getPath() + File.separator + "playersData");
        try {
            File dataFile;
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if ((dataFile = new File(folder, String.valueOf(player.getUniqueId()) + ".json")).exists()) {
                return dataFile;
            }
            dataFile.createNewFile();
            return dataFile;
        }
        catch (IOException error) {
            return null;
        }
    }

    public static File[] getWorldsFolders() {
        File[] planetsWorlds;
        ArrayList<File> worldsFolders = new ArrayList<File>();
        File planetsFolder = FileUtils.getPlanetsStorageFolder();
        if (!planetsFolder.exists()) {
            planetsFolder.mkdirs();
        }
        if ((planetsWorlds = planetsFolder.listFiles()) == null) {
            return worldsFolders.toArray(new File[0]);
        }
        for (File file : planetsWorlds) {
            if (!FileUtils.isPlanetFolder(file)) continue;
            worldsFolders.add(file);
        }
        return worldsFolders.toArray(new File[0]);
    }

    public static File[] getModulesFiles() {
        File[] modulesFiles;
        ArrayList<File> modules = new ArrayList<File>();
        File modulesFolder = FileUtils.getModulesStorageFolder();
        if (!modulesFolder.exists()) {
            modulesFolder.mkdirs();
        }
        if ((modulesFiles = modulesFolder.listFiles()) == null) {
            return modules.toArray(new File[0]);
        }
        for (File moduleFile : modulesFiles) {
            if (moduleFile.isDirectory() || !moduleFile.getName().endsWith(".yml")) continue;
            modules.add(moduleFile);
        }
        return modules.toArray(new File[0]);
    }

    public static void convertOldPlanetFolders() {
        File[] unloadedWorlds;
        File unloadedWorldsFolder;
        File serverDirectory = Bukkit.getServer().getWorldContainer();
        File[] serverDirectoryFiles = serverDirectory.listFiles();
        int count = 0;
        if (serverDirectoryFiles != null) {
            for (File file : serverDirectoryFiles) {
                if (!FileUtils.convertOldPlanetFolder(file)) continue;
                ++count;
            }
        }
        if ((unloadedWorldsFolder = new File(String.valueOf(serverDirectory) + File.separator + "unloadedWorlds" + File.separator)).exists() && (unloadedWorlds = unloadedWorldsFolder.listFiles()) != null) {
            for (File file : unloadedWorlds) {
                if (!FileUtils.convertOldPlanetFolder(file)) continue;
                ++count;
            }
            unloadedWorlds = unloadedWorldsFolder.listFiles();
            if (unloadedWorlds != null && unloadedWorlds.length == 0) {
                unloadedWorldsFolder.delete();
            }
        }
        if (count > 0) {
            OpenCreative.getPlugin().getLogger().info("Converted " + count + " old worlds!");
        }
    }

    public static boolean convertOldPlanetFolder(File folder) {
        try {
            boolean converted = false;
            if (folder.getName().startsWith("plot")) {
                OpenCreative.getPlugin().getLogger().info("Renaming " + folder.getName() + " to " + folder.getName().replace("plot", "planet") + "...");
                File newFile = new File(folder.getParent() + File.separator + folder.getName().replace("plot", "planet"));
                folder.renameTo(newFile);
                folder = newFile;
                converted = true;
            }
            if (folder.getPath().contains("planet") && !folder.getPath().contains("planets")) {
                OpenCreative.getPlugin().getLogger().info("Moving " + folder.getName() + " to planets folder...");
                File newFolder = new File(FileUtils.getPlanetsStorageFolder().getPath() + File.separator + folder.getName());
                FileUtils.copyFilesToDirectory(folder, newFolder);
                FileUtils.deleteFolder(folder);
                folder = newFolder;
                converted = true;
            }
            return converted;
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Can't rename from plot to planet: " + folder.getName(), error);
            return false;
        }
    }

    public static boolean isPlanetFolder(File folder) {
        return folder.isDirectory() && folder.getName().startsWith("planet") && folder.getPath().contains(FileUtils.getPlanetsStorageFolder().getPath());
    }

    public static void unloadPlanets() {
        OpenCreative.getPlugin().getLogger().info("Unloading worlds, please wait...");
        try {
            for (Planet planet : OpenCreative.getPlanetsManager().getPlanets()) {
                if (planet.isLoaded()) {
                    OpenCreative.getPlugin().getLogger().info("Unloading planet " + planet.getId() + "...");
                    planet.getTerritory().unload();
                    continue;
                }
                if (!planet.getDevPlanet().isLoaded()) continue;
                OpenCreative.getPlugin().getLogger().info("Unloading planet dev " + planet.getId() + "...");
                planet.getDevPlanet().unload();
            }
            OpenCreative.getPlanetsManager().getPlanets().clear();
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Error while unloading worlds.", error);
        }
    }

    public static boolean copyFilesToDirectory(File input, File output) {
        try {
            File[] inputFiles = input.listFiles();
            if (!output.exists() && !output.mkdirs()) {
                ErrorUtils.sendCriticalErrorMessage("Can't create a output directory " + output.getPath() + " for copying from input " + input.getPath());
            }
            if (inputFiles != null) {
                for (File worldFile : inputFiles) {
                    if (worldFile.isDirectory()) {
                        org.apache.commons.io.FileUtils.copyDirectoryToDirectory(worldFile, output);
                        continue;
                    }
                    org.apache.commons.io.FileUtils.copyFileToDirectory(worldFile, output);
                }
            }
            return true;
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't copy files from directory " + input.getPath() + " to directory: " + output.getPath(), error);
            return false;
        }
    }

    public static void deleteUnnecessaryWorldFiles(File worldFolder) {
        try {
            if (!worldFolder.exists()) {
                return;
            }
            File uidFile = new File(worldFolder, "uid.dat");
            File sessionFile = new File(worldFolder, "session.lock");
            uidFile.delete();
            sessionFile.delete();
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Cannot delete uid.dat file.", error);
        }
    }

    public static void deleteFolder(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (directory.equals(Bukkit.getWorldContainer())) {
            return;
        }
        try {
            org.apache.commons.io.FileUtils.deleteDirectory(directory);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Couldn't delete a folder with path " + directory.getPath(), error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, long parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, (Object)String.valueOf(parameterValue));
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, int parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, (Object)String.valueOf(parameterValue));
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, Object parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, parameterValue);
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static void setModuleConfigParameter(Module module, String parameterPath, Object parameterValue) {
        FileConfiguration moduleConfig = FileUtils.getModuleConfig(module);
        File moduleConfigFile = FileUtils.getModuleConfigFile(module.getId());
        moduleConfig.set(parameterPath, parameterValue);
        try {
            moduleConfig.save(moduleConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save module's settings configuration to file.", error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, String parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, (Object)parameterValue);
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, List<String> parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, parameterValue);
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static void setPlanetConfigParameter(Planet planet, String parameterPath, Set<String> parameterValue) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        File planetConfigFile = FileUtils.getPlanetConfigFile(planet);
        planetConfig.set(parameterPath, new ArrayList<String>(parameterValue));
        try {
            planetConfig.save(planetConfigFile);
        }
        catch (IOException error) {
            ErrorUtils.sendCriticalErrorMessage("Can't save planet's settings configuration to file.", error);
        }
    }

    public static List<String> getPlayersFromPlanetList(Planet planet, Planet.PlayersType type) {
        return new ArrayList<String>(FileUtils.getPlanetConfig(planet).getStringList(type.getPath()));
    }

    public static boolean addPlayerInPlanetList(Planet planet, String nickname, Planet.PlayersType type) {
        FileConfiguration planetConfig = FileUtils.getPlanetConfig(planet);
        List playersList = planetConfig.getStringList(type.getPath());
        for (String player : playersList) {
            if (!player.equalsIgnoreCase(nickname)) continue;
            return false;
        }
        playersList.add(nickname);
        FileUtils.setPlanetConfigParameter(planet, type.getPath(), playersList);
        return true;
    }

    public static long getFolderSize(File file) {
        try {
            return org.apache.commons.io.FileUtils.sizeOfDirectory(file);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static FileConfiguration getModuleConfig(Module module) {
        return YamlConfiguration.loadConfiguration((File)FileUtils.getModuleConfigFile(module.getId()));
    }

    public static File getModuleConfigFile(int id) {
        return new File(FileUtils.getModulesStorageFolder(), "module" + id + ".yml");
    }

    public static File getModulesStorageFolder() {
        return new File(Bukkit.getWorldContainer().getPath() + File.separator + "modules" + File.separator);
    }

    public static long getFileSize(File file) {
        try {
            return org.apache.commons.io.FileUtils.sizeOf(file);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static String getPlanetFolderPath(Planet planet) {
        return FileUtils.getPlanetsStorageFolder().getPath() + File.separator + "planet" + planet.getId() + File.separator;
    }

    public static File getPlanetsStorageFolder() {
        return new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator);
    }

    public static File getWandersStorageFolder() {
        return new File(Bukkit.getWorldContainer().getPath() + File.separator + "wanders" + File.separator);
    }

    public static String getPlanetIdFromName(String name) {
        return name.replace(Bukkit.getServer().getWorldContainer().getPath().replace("\\", "/") + "/", "").replace("planets/planet", "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wander", "ua/mcchickenstudio/opencreative/utils/FileUtils", "getWanderJsonFile"));
    }
}

