/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

public final class FastMath {
    private static final float[] SIN_TABLE_FAST;
    private static final float[] SIN_TABLE;
    private static final int[] multiplyDeBruijnBitPosition;

    public static float sin(float value) {
        return SIN_TABLE[(int)(value * 10430.378f) & 0xFFFF];
    }

    public static float cos(float value) {
        return SIN_TABLE[(int)(value * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float fastSin(float value) {
        return SIN_TABLE_FAST[(int)(value * 651.8986f) & 0xFFF];
    }

    public static float fastCos(float value) {
        return SIN_TABLE_FAST[(int)((value + 1.5707964f) * 651.8986f) & 0xFFF];
    }

    private static boolean isPowerOfTwo(int value) {
        return value != 0 && (value & value - 1) == 0;
    }

    private static int calculateLogBaseTwoDeBruijn(int value) {
        value = FastMath.isPowerOfTwo(value) ? value : FastMath.roundUpToPowerOfTwo(value);
        return multiplyDeBruijnBitPosition[(int)((long)value * 125613361L >> 27) & 0x1F];
    }

    public static int roundUpToPowerOfTwo(int value) {
        int var1 = value - 1;
        var1 |= var1 >> 1;
        var1 |= var1 >> 2;
        var1 |= var1 >> 4;
        var1 |= var1 >> 8;
        var1 |= var1 >> 16;
        return var1 + 1;
    }

    public static int floor(double value) {
        int var2 = (int)value;
        return value < (double)var2 ? var2 - 1 : var2;
    }

    public static int calculateLogBaseTwo(int i) {
        return FastMath.calculateLogBaseTwoDeBruijn(i) - (FastMath.isPowerOfTwo(i) ? 0 : 1);
    }

    static {
        int i;
        SIN_TABLE_FAST = new float[4096];
        SIN_TABLE = new float[65536];
        for (i = 0; i < 65536; ++i) {
            FastMath.SIN_TABLE[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
        multiplyDeBruijnBitPosition = new int[]{0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9};
        for (i = 0; i < 4096; ++i) {
            FastMath.SIN_TABLE_FAST[i] = (float)Math.sin(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
        }
        for (i = 0; i < 360; i += 90) {
            FastMath.SIN_TABLE_FAST[(int)((float)i * 11.377778f) & 0xFFF] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
    }
}

