/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

public final class Interpolation {
    public static double interpolate(double from, double to, double percent, Type type, Ease ease) {
        return switch (type.ordinal()) {
            case 1 -> Interpolation.sineInterpolation(from, to, percent, ease);
            case 2 -> Interpolation.quadInterpolation(from, to, percent, ease);
            case 3 -> Interpolation.cubicInterpolation(from, to, percent, ease);
            case 4 -> Interpolation.quartInterpolation(from, to, percent, ease);
            case 5 -> Interpolation.quintInterpolation(from, to, percent, ease);
            case 6 -> Interpolation.expoInterpolation(from, to, percent, ease);
            case 7 -> Interpolation.circInterpolation(from, to, percent, ease);
            case 8 -> Interpolation.backInterpolation(from, to, percent, ease);
            case 9 -> Interpolation.bounceInterpolation(from, to, percent, ease);
            case 10 -> Interpolation.elasticInterpolation(from, to, percent, ease);
            default -> Interpolation.linearInterpolation(from, to, percent);
        };
    }

    public static double linearInterpolation(double from, double to, double percent) {
        return from + (to - from) * percent;
    }

    public static double sineInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent = 1.0 - Math.cos(percent * Math.PI / 2.0);
                break;
            }
            case 1: {
                percent = Math.sin(percent * Math.PI / 2.0);
                break;
            }
            case 2: {
                percent = -0.5 * (Math.cos(Math.PI * percent) - 1.0);
            }
        }
        return from + (to - from) * percent;
    }

    public static double quadInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent *= percent;
                break;
            }
            case 1: {
                percent *= 2.0 - percent;
                break;
            }
            case 2: {
                percent = percent < 0.5 ? 2.0 * percent * percent : -1.0 + (4.0 - 2.0 * percent) * percent;
            }
        }
        return from + (to - from) * percent;
    }

    public static double cubicInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent *= percent * percent;
                break;
            }
            case 1: {
                percent -= 1.0;
                percent = percent * percent * percent + 1.0;
                break;
            }
            case 2: {
                percent = percent < 0.5 ? 4.0 * percent * percent * percent : (percent - 1.0) * (2.0 * percent - 2.0) * (2.0 * percent - 2.0) + 1.0;
            }
        }
        return from + (to - from) * percent;
    }

    public static double quartInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent *= percent * percent * percent;
                break;
            }
            case 1: {
                percent -= 1.0;
                percent = 1.0 - percent * percent * percent * percent;
                break;
            }
            case 2: {
                if (percent < 0.5) {
                    percent = 8.0 * percent * percent * percent * percent;
                    break;
                }
                percent -= 1.0;
                percent = 1.0 - 8.0 * percent * percent * percent * percent;
            }
        }
        return from + (to - from) * percent;
    }

    public static double quintInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent *= percent * percent * percent * percent;
                break;
            }
            case 1: {
                percent -= 1.0;
                percent = 1.0 + percent * percent * percent * percent * percent;
                break;
            }
            case 2: {
                if (percent < 0.5) {
                    percent = 16.0 * percent * percent * percent * percent * percent;
                    break;
                }
                percent -= 1.0;
                percent = 1.0 + 16.0 * percent * percent * percent * percent * percent;
            }
        }
        return from + (to - from) * percent;
    }

    public static double expoInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent = percent == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * (percent - 1.0));
                break;
            }
            case 1: {
                percent = percent == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * percent);
                break;
            }
            case 2: {
                if (percent == 0.0 || percent == 1.0) {
                    return from + (to - from) * percent;
                }
                percent = percent < 0.5 ? Math.pow(2.0, 20.0 * percent - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * percent + 10.0)) / 2.0;
            }
        }
        return from + (to - from) * percent;
    }

    public static double circInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent = 1.0 - Math.sqrt(1.0 - percent * percent);
                break;
            }
            case 1: {
                percent -= 1.0;
                percent = Math.sqrt(1.0 - percent * percent);
                break;
            }
            case 2: {
                if (percent < 0.5) {
                    percent = (1.0 - Math.sqrt(1.0 - 4.0 * percent * percent)) / 2.0;
                    break;
                }
                percent -= 1.0;
                percent = (Math.sqrt(1.0 - 4.0 * percent * percent) + 1.0) / 2.0;
            }
        }
        return from + (to - from) * percent;
    }

    public static double backInterpolation(double from, double to, double percent, Ease ease) {
        double s = 1.70158;
        switch (ease.ordinal()) {
            case 0: {
                percent = percent * percent * ((s + 1.0) * percent - s);
                break;
            }
            case 1: {
                percent -= 1.0;
                percent = percent * percent * ((s + 1.0) * percent + s) + 1.0;
                break;
            }
            case 2: {
                s *= 1.525;
                if (percent < 0.5) {
                    percent = percent * 2.0 * percent * ((s + 1.0) * percent - s) * 0.5;
                    break;
                }
                percent -= 1.0;
                percent = (percent * 2.0 * percent * ((s + 1.0) * percent + s) + 1.0) * 0.5;
            }
        }
        return from + (to - from) * percent;
    }

    public static double bounceInterpolation(double from, double to, double percent, Ease ease) {
        switch (ease.ordinal()) {
            case 0: {
                percent = 1.0 - Interpolation.bounceOut(1.0 - percent);
                break;
            }
            case 1: {
                percent = Interpolation.bounceOut(percent);
                break;
            }
            case 2: {
                percent = percent < 0.5 ? (1.0 - Interpolation.bounceOut(1.0 - 2.0 * percent)) * 0.5 : (Interpolation.bounceOut(2.0 * percent - 1.0) + 1.0) * 0.5;
            }
        }
        return from + (to - from) * percent;
    }

    private static double bounceOut(double percent) {
        if (percent < 0.36363636363636365) {
            return 7.5625 * percent * percent;
        }
        if (percent < 0.7272727272727273) {
            return 7.5625 * (percent -= 0.5454545454545454) * percent + 0.75;
        }
        if (percent < 0.9090909090909091) {
            return 7.5625 * (percent -= 0.8181818181818182) * percent + 0.9375;
        }
        return 7.5625 * (percent -= 0.9545454545454546) * percent + 0.984375;
    }

    public static double elasticInterpolation(double from, double to, double percent, Ease ease) {
        double p = 0.3;
        switch (ease.ordinal()) {
            case 0: {
                if (percent == 0.0 || percent == 1.0) {
                    return percent;
                }
                percent = -(Math.pow(2.0, 10.0 * (percent - 1.0)) * Math.sin((percent - 1.0 - p / 4.0) * (Math.PI * 2) / p));
                break;
            }
            case 1: {
                if (percent == 0.0 || percent == 1.0) {
                    return percent;
                }
                percent = Math.pow(2.0, -10.0 * percent) * Math.sin((percent - p / 4.0) * (Math.PI * 2) / p) + 1.0;
                break;
            }
            case 2: {
                if (percent == 0.0 || percent == 1.0) {
                    return percent;
                }
                percent = percent < 0.5 ? -(Math.pow(2.0, 10.0 * (percent * 2.0 - 1.0)) * Math.sin((percent * 2.0 - 1.0 - p / 4.0) * (Math.PI * 2) / p)) * 0.5 : Math.pow(2.0, -10.0 * (percent * 2.0 - 1.0)) * Math.sin((percent * 2.0 - 1.0 - p / 4.0) * (Math.PI * 2) / p) * 0.5 + 1.0;
            }
        }
        return from + (to - from) * percent;
    }

    public static enum Type {
        LINEAR,
        SINE,
        QUAD,
        CUBIC,
        QUART,
        QUINT,
        EXPO,
        CIRC,
        BACK,
        BOUNCE,
        ELASTIC;

    }

    public static enum Ease {
        IN,
        OUT,
        IN_OUT;

    }
}

