/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

import ua.mcchickenstudio.opencreative.utils.millennium.math.BlockPos;
import ua.mcchickenstudio.opencreative.utils.millennium.math.EnumFacing;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class MovingObjectPosition {
    public MovingObjectType typeOfHit;
    public EnumFacing sideHit;
    public Vec3 hitVec;
    private BlockPos blockPos;

    public MovingObjectPosition(Vec3 hitVecIn, EnumFacing facing, BlockPos blockPosIn) {
        this(MovingObjectType.BLOCK, hitVecIn, facing, blockPosIn);
    }

    public MovingObjectPosition(Vec3 vec3, EnumFacing facing) {
        this(MovingObjectType.BLOCK, vec3, facing, BlockPos.ORIGIN);
    }

    public MovingObjectPosition(MovingObjectType typeOfHitIn, Vec3 hitVecIn, EnumFacing sideHitIn, BlockPos blockPosIn) {
        this.typeOfHit = typeOfHitIn;
        this.blockPos = blockPosIn;
        this.sideHit = sideHitIn;
        this.hitVec = new Vec3(hitVecIn.xCoord, hitVecIn.yCoord, hitVecIn.zCoord);
    }

    public MovingObjectPosition(Vec3 hitVecIn) {
        this.typeOfHit = MovingObjectType.ENTITY;
        this.hitVec = hitVecIn;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public String toString() {
        return "HitResult{type=" + String.valueOf((Object)this.typeOfHit) + ", blockpos=" + String.valueOf(this.blockPos) + ", f=" + String.valueOf((Object)this.sideHit) + ", pos=" + String.valueOf(this.hitVec) + "}";
    }

    public static enum MovingObjectType {
        MISS,
        BLOCK,
        ENTITY;

    }
}

