/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.phys;

import lombok.Generated;
import ua.mcchickenstudio.opencreative.utils.millennium.phys.MotionValue;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class Motion {
    private final MotionValue x;
    private final MotionValue y;
    private final MotionValue z;

    public Motion() {
        this.x = new MotionValue(0.0);
        this.y = new MotionValue(0.0);
        this.z = new MotionValue(0.0);
    }

    public Motion(double x, double y, double z) {
        this.x = new MotionValue(x);
        this.y = new MotionValue(y);
        this.z = new MotionValue(z);
    }

    public Motion(MotionValue x, MotionValue y, MotionValue z) {
        this.x = new MotionValue(x.get());
        this.y = new MotionValue(y.get());
        this.z = new MotionValue(z.get());
    }

    public void set(Vec3 vector) {
        this.x.set(vector.xCoord);
        this.y.set(vector.yCoord);
        this.z.set(vector.zCoord);
    }

    public void add(Vec3 vector) {
        this.x.add(vector.xCoord);
        this.y.add(vector.yCoord);
        this.z.add(vector.zCoord);
    }

    public double distanceSquared(Motion other) {
        return Math.pow(this.x.get() - other.getX().get(), 2.0) + Math.pow(this.y.get() - other.getY().get(), 2.0) + Math.pow(this.z.get() - other.getZ().get(), 2.0);
    }

    public double length() {
        return Math.sqrt(this.x.get() * this.x.get() + this.y.get() * this.y.get() + this.z.get() * this.z.get());
    }

    public Motion normalize() {
        double d0 = this.length();
        return d0 < 1.0E-4 ? new Motion(0.0, 0.0, 0.0) : new Motion(this.x.get() / d0, this.y.get() / d0, this.z.get() / d0);
    }

    public Motion clone() {
        return new Motion(this.x.get(), this.y.get(), this.z.get());
    }

    @Generated
    public MotionValue getX() {
        return this.x;
    }

    @Generated
    public MotionValue getY() {
        return this.y;
    }

    @Generated
    public MotionValue getZ() {
        return this.z;
    }
}

