/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.shapes;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import ua.mcchickenstudio.opencreative.utils.millennium.math.BuildSpeed;
import ua.mcchickenstudio.opencreative.utils.millennium.math.GeneralMath;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2;

public final class Circle {
    private final List<Vec2> vectors = new ArrayList<Vec2>();

    public void build(BuildSpeed s, double size, double round, int res) {
        this.vectors.clear();
        Vec2 firstVector = null;
        for (int k = 0; k <= 720; k += res) {
            double x = GeneralMath.sin((float)Math.toRadians(k), s) * (float)res;
            double y = GeneralMath.cos((float)Math.toRadians(k), s) * (float)res;
            double xj = x / Math.max(Math.abs(x), 1.0) * round;
            double yj = y / Math.max(Math.abs(y), 1.0) * round;
            Vec2 v2 = new Vec2(xj * size, yj * size);
            if (k == 0) {
                firstVector = v2;
            } else if (v2.compare(firstVector)) break;
            this.vectors.add(v2);
        }
    }

    @Generated
    public List<Vec2> getVectors() {
        return this.vectors;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        List<Vec2> this$vectors = this.getVectors();
        List<Vec2> other$vectors = other.getVectors();
        return !(this$vectors == null ? other$vectors != null : !((Object)this$vectors).equals(other$vectors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Vec2> $vectors = this.getVectors();
        result = result * 59 + ($vectors == null ? 43 : ((Object)$vectors).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Circle(vectors=" + String.valueOf(this.getVectors()) + ")";
    }
}

