/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.vectors;

import lombok.Generated;

public final class Vec2f {
    private float x;
    private float y;

    public Vec2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vec2f(Number x, Number y) {
        this.x = x.floatValue();
        this.y = y.floatValue();
    }

    public double distance(Vec2f vector2) {
        return Math.sqrt(Math.pow(this.x - vector2.x, 2.0) + Math.pow(this.y - vector2.y, 2.0));
    }

    public Vec2f add(Vec2f vector2) {
        return new Vec2f(this.x + vector2.x, this.y + vector2.y);
    }

    public Vec2f subtract(Vec2f vector2) {
        return new Vec2f(this.x - vector2.x, this.y - vector2.y);
    }

    public Vec2f scale(double factor) {
        return new Vec2f((double)this.x * factor, (double)this.y * factor);
    }

    public boolean compare(Vec2f vector2) {
        return this.x == vector2.x && this.y == vector2.y;
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vec2f)) {
            return false;
        }
        Vec2f other = (Vec2f)o;
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Float.compare(this.getY(), other.getY()) == 0;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        return result;
    }

    @Generated
    public String toString() {
        return "Vec2f(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

