/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.bukkit.World;

public final class ChunkCache {
    private static final Map<Long, Boolean> statusKeeper = new ConcurrentHashMap<Long, Boolean>();

    public static boolean isChunkGenerated(World world, int i, int i1) {
        if (world == null) {
            return false;
        }
        long hash = ChunkCache.hash(world, i, i1);
        return statusKeeper.computeIfAbsent(hash, k -> world.isChunkGenerated(i, i1));
    }

    public static void preCheck(World world, int i, int i1) {
        if (world == null) {
            return;
        }
        long hash = ChunkCache.hash(world, i, i1);
        statusKeeper.computeIfAbsent(hash, k -> world.isChunkGenerated(i, i1));
    }

    public static void preLoad(World world, int i, int i1) {
        if (world == null) {
            return;
        }
        long hash = ChunkCache.hash(world, i, i1);
        statusKeeper.putIfAbsent(hash, true);
    }

    public static void unload(World world, int i, int i1) {
        if (world == null) {
            return;
        }
        long hash = ChunkCache.hash(world, i, i1);
        statusKeeper.putIfAbsent(hash, false);
    }

    private static long hash(World world, int i, int i1) {
        return (31L * (long)i + (long)i1 + (long)world.getUID().hashCode()) * 31L;
    }

    @Generated
    private ChunkCache() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

