/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorCategory;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;

public class CodeConfiguration
extends YamlConfiguration {
    @NotNull
    public static CodeConfiguration loadConfiguration(@NotNull File file) {
        if (file == null) {
            CodeConfiguration.$$$reportNull$$$0(0);
        }
        CodeConfiguration config = new CodeConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException | InvalidConfigurationException ex) {
            OpenCreative.getPlugin().getLogger().log(Level.SEVERE, "Cannot load " + String.valueOf(file), ex);
        }
        CodeConfiguration codeConfiguration = config;
        if (codeConfiguration == null) {
            CodeConfiguration.$$$reportNull$$$0(1);
        }
        return codeConfiguration;
    }

    public void saveExecutorBlock(Block block, boolean notDependsOnHeight, ExecutorCategory category, ExecutorType type) {
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        String path = "code.blocks.exec_block_" + (notDependsOnHeight ? z : y) + "_" + x;
        this.set(path + ".category", category.name());
        this.set(path + ".type", type.name());
        String firstSignLine = BlockUtils.getSignLine(block.getRelative(BlockFace.SOUTH).getLocation(), 1);
        String thirdSignLine = BlockUtils.getSignLine(block.getRelative(BlockFace.SOUTH).getLocation(), 3);
        if (category == ExecutorCategory.FUNCTION || category == ExecutorCategory.METHOD) {
            if (thirdSignLine != null && !thirdSignLine.isEmpty()) {
                this.set(path + ".name", thirdSignLine);
            }
        } else if (category == ExecutorCategory.CYCLE) {
            if (thirdSignLine != null && !thirdSignLine.isEmpty()) {
                this.set(path + ".time", Integer.parseInt(thirdSignLine));
            }
            if (firstSignLine != null && !firstSignLine.isEmpty()) {
                this.set(path + ".name", firstSignLine);
            }
        }
        this.set(path + ".location.x", x);
        this.set(path + ".location.y", y);
        this.set(path + ".location.z", z);
    }

    public void saveActionBlock(Block executorBlock, boolean notDependsOnHeight, List<String> multiActions, Block actionBlock, ActionCategory category, ActionType type, Target target) {
        String firstSignLine;
        String thirdSignLine;
        String path = this.getActionBlockPath(executorBlock, notDependsOnHeight, actionBlock, multiActions);
        this.set(path + ".category", category.name());
        this.set(path + ".type", type.name());
        if (!(type != ActionType.LAUNCH_FUNCTION && type != ActionType.LAUNCH_METHOD || (thirdSignLine = BlockUtils.getSignLine(actionBlock.getRelative(BlockFace.SOUTH).getLocation(), 3)) == null || thirdSignLine.isEmpty())) {
            this.set(path + ".name", thirdSignLine);
        }
        if (category == ActionCategory.SELECTION_ACTION) {
            firstSignLine = BlockUtils.getSignLine(actionBlock.getRelative(BlockFace.SOUTH).getLocation(), 1);
            String secondSignLine = BlockUtils.getSignLine(actionBlock.getRelative(BlockFace.SOUTH).getLocation(), 2);
            String thirdSignLine2 = BlockUtils.getSignLine(actionBlock.getRelative(BlockFace.SOUTH).getLocation(), 3);
            if (secondSignLine != null && !secondSignLine.isEmpty() && thirdSignLine2 != null && !thirdSignLine2.isEmpty()) {
                this.set(path + ".condition.category", secondSignLine.toUpperCase());
                this.set(path + ".condition.type", thirdSignLine2.toUpperCase());
                if (firstSignLine != null && firstSignLine.equalsIgnoreCase("not")) {
                    this.set(path + ".condition.opposed", true);
                }
            } else if (secondSignLine != null && !secondSignLine.isEmpty()) {
                this.set(path + ".target", secondSignLine.toUpperCase());
            }
        } else if (target != Target.DEFAULT) {
            this.set(path + ".target", target.name());
        }
        if (category.isCondition() && (firstSignLine = BlockUtils.getSignLine(actionBlock.getRelative(BlockFace.SOUTH).getLocation(), 1)) != null && firstSignLine.equalsIgnoreCase("not")) {
            this.set(path + ".opposed", true);
        }
        this.set(path + ".location.x", actionBlock.getX());
        this.createSection(path + ".arguments");
    }

    public void saveArguments(Block executorBlock, boolean notDependsOnHeight, List<String> multiActions, Block actionBlock, String argument, Object value, ValueType type) {
        String path = this.getActionBlockPath(executorBlock, notDependsOnHeight, actionBlock, multiActions);
        this.set(path + ".arguments." + argument + ".type", type.name());
        this.set(path + ".arguments." + argument + ".value", value);
    }

    private String getActionBlockPath(Block executorBlock, boolean notDependsOnHeight, Block actionBlock, List<String> multiActions) {
        int z = notDependsOnHeight ? actionBlock.getZ() : actionBlock.getY();
        StringBuilder conditionsPath = new StringBuilder();
        for (String condition : multiActions) {
            conditionsPath.append(condition.endsWith(".else") ? condition.replace(".else", "") : condition).append(condition.endsWith(".else") ? ".else." : ".actions.");
        }
        String path = "code.blocks.exec_block_";
        StringBuilder builder = new StringBuilder(path);
        builder.append(z);
        builder.append("_");
        builder.append(executorBlock.getX());
        builder.append(".actions.");
        builder.append((CharSequence)conditionsPath);
        ActionCategory category = ActionCategory.getByMaterial(actionBlock.getType());
        if (category != null && category.isMultiAction()) {
            builder.delete(builder.length() - 9, builder.length());
        } else {
            builder.append("action_block").append(this.getBlockNumber(actionBlock));
        }
        return builder.toString();
    }

    public int getBlockNumber(Block block) {
        return (block.getX() - 2) / 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/CodeConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/CodeConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadConfiguration";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

