/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.arguments;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.apache.commons.lang3.math.NumberUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.coding.arguments.Argument;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.EventValueLink;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public class Arguments {
    @NotNull
    private final Planet planet;
    @NotNull
    private final Executor executor;
    @NotNull
    private final List<Argument> argumentList;
    private static final Pattern INT_PATTERN = Pattern.compile("^-?[0-9]*$");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^-?[0-9]*\\.?[0-9]+$");

    public Arguments(@NotNull Planet planet, @NotNull Executor executor) {
        if (planet == null) {
            Arguments.$$$reportNull$$$0(0);
        }
        if (executor == null) {
            Arguments.$$$reportNull$$$0(1);
        }
        this.argumentList = new ArrayList<Argument>();
        this.planet = planet;
        this.executor = executor;
    }

    public final void load(ConfigurationSection section) {
        for (String path : section.getKeys(false)) {
            Argument arg = this.loadArgument(section, path);
            if (arg == null) continue;
            this.argumentList.add(arg);
        }
    }

    private Argument loadArgument(ConfigurationSection section, String name) {
        String configType = section.getString(name + ".type");
        Object configValue = section.get(name + ".value");
        if (configType == null || configType.isEmpty() || configValue == null) {
            return null;
        }
        ValueType type = ValueType.parseString(configType.toUpperCase());
        Object value = this.parseValue(section, name, type, configValue);
        return new Argument(this.planet, type, name, value);
    }

    @NotNull
    private Object parseValue(ConfigurationSection section, String name, ValueType type, Object configValue) {
        String stringValue = configValue.toString();
        ConfigurationSection listSection = section.getConfigurationSection(name + ".value");
        switch (type) {
            case LIST: {
                ArrayList<Argument> arguments = new ArrayList<Argument>();
                if (listSection == null) {
                    ArrayList<Argument> arrayList = arguments;
                    if (arrayList == null) {
                        Arguments.$$$reportNull$$$0(2);
                    }
                    return arrayList;
                }
                for (String key : listSection.getKeys(false)) {
                    Argument argument = this.loadArgument(listSection, key);
                    if (argument == null) continue;
                    arguments.add(argument);
                }
                ArrayList<Argument> arrayList = arguments;
                if (arrayList == null) {
                    Arguments.$$$reportNull$$$0(3);
                }
                return arrayList;
            }
            case LOCATION: {
                if (listSection == null) {
                    Location location = this.planet.getTerritory().getWorld().getSpawnLocation();
                    if (location == null) {
                        Arguments.$$$reportNull$$$0(4);
                    }
                    return location;
                }
                double x = listSection.getDouble("x");
                double y = listSection.getDouble("y");
                double z = listSection.getDouble("z");
                float yaw = (float)listSection.getDouble("yaw");
                float pitch = (float)listSection.getDouble("pitch");
                return new Location(this.planet.getTerritory().getWorld(), x, y, z, yaw, pitch);
            }
            case VECTOR: {
                if (listSection == null) {
                    return new Vector(0, 0, 0);
                }
                double x = listSection.getDouble("x");
                double y = listSection.getDouble("y");
                double z = listSection.getDouble("z");
                return new Vector(x, y, z);
            }
            case COLOR: {
                if (listSection == null) {
                    Color color = Color.WHITE;
                    if (color == null) {
                        Arguments.$$$reportNull$$$0(5);
                    }
                    return color;
                }
                int r = listSection.getInt("red");
                int g = listSection.getInt("blue");
                int b = listSection.getInt("green");
                if (r >= 0 && r <= 255 && g >= 0 && g <= 255 && b >= 0 && b <= 255) {
                    Color color = Color.fromRGB((int)r, (int)g, (int)b);
                    if (color == null) {
                        Arguments.$$$reportNull$$$0(6);
                    }
                    return color;
                }
                Color color = Color.WHITE;
                if (color == null) {
                    Arguments.$$$reportNull$$$0(7);
                }
                return color;
            }
            case VARIABLE: {
                if (listSection == null) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(8);
                    }
                    return string;
                }
                String varName = listSection.getString("name", "");
                String typeString = listSection.getString("type");
                VariableLink.VariableType varType = VariableLink.VariableType.getEnum(typeString);
                if (varType == null) {
                    varType = VariableLink.VariableType.GLOBAL;
                }
                return new VariableLink(varName, varType);
            }
            case EVENT_VALUE: {
                if (listSection == null) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(9);
                    }
                    return string;
                }
                String valueType = listSection.getString("name");
                String targetType = listSection.getString("target", "selected");
                if (valueType == null) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(10);
                    }
                    return string;
                }
                if (valueType.isEmpty()) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                Target target = Target.getByText(targetType);
                try {
                    if (valueType.startsWith("PLOT")) {
                        valueType = valueType.replace("PLOT", "PLANET");
                    }
                    return new EventValueLink(valueType, target);
                }
                catch (Exception e) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(12);
                    }
                    return string;
                }
            }
            case NUMBER: {
                if (INT_PATTERN.matcher(stringValue).matches()) {
                    Integer n = Integer.parseInt(stringValue);
                    if (n == null) {
                        Arguments.$$$reportNull$$$0(13);
                    }
                    return n;
                }
                if (FLOAT_PATTERN.matcher(stringValue).matches()) {
                    Float f = Float.valueOf(Float.parseFloat(stringValue));
                    if (f == null) {
                        Arguments.$$$reportNull$$$0(14);
                    }
                    return f;
                }
                Integer n = 0;
                if (n == null) {
                    Arguments.$$$reportNull$$$0(15);
                }
                return n;
            }
            case BOOLEAN: {
                Boolean bl = Boolean.parseBoolean(stringValue);
                if (bl == null) {
                    Arguments.$$$reportNull$$$0(16);
                }
                return bl;
            }
            case PARAMETER: {
                Float f = Float.valueOf(Float.parseFloat(stringValue));
                if (f == null) {
                    Arguments.$$$reportNull$$$0(17);
                }
                return f;
            }
            case ITEM: {
                if (listSection == null) {
                    return new ItemStack(Material.AIR);
                }
                ItemStack itemStack = ItemStack.deserialize((Map)listSection.getValues(false));
                if (itemStack == null) {
                    Arguments.$$$reportNull$$$0(18);
                }
                return itemStack;
            }
            case PARTICLE: {
                Particle particle;
                if (listSection == null) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(19);
                    }
                    return string;
                }
                String typeString = listSection.getString("type");
                if (typeString == null || typeString.isEmpty()) {
                    String string = stringValue;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(20);
                    }
                    return string;
                }
                try {
                    particle = Particle.valueOf((String)typeString);
                }
                catch (Exception e) {
                    String string = typeString;
                    if (string == null) {
                        Arguments.$$$reportNull$$$0(22);
                    }
                    return string;
                }
                if (particle == null) {
                    Arguments.$$$reportNull$$$0(21);
                }
                return particle;
            }
        }
        String string = stringValue;
        if (string == null) {
            Arguments.$$$reportNull$$$0(23);
        }
        return string;
    }

    public final boolean pathExists(String path) {
        for (Argument argument : this.argumentList) {
            if (!argument.getPath().equals(path)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private Argument getArg(String path) {
        for (Argument argument : this.argumentList) {
            if (!argument.getPath().equals(path)) continue;
            return argument;
        }
        return null;
    }

    public final <T> Map<T, T> getMap(String path, Action action) {
        HashMap map = new HashMap();
        Argument arg = this.getArg(path);
        if (arg != null) {
            try {
                if (arg.getType() == ValueType.VARIABLE) {
                    return (Map)arg.getValue(action);
                }
            }
            catch (ClassCastException e) {
                return map;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, map);
        return map;
    }

    public final <T> List<T> getList(String path, Action action) {
        ArrayList<Object> list = new ArrayList<Object>();
        Argument arg = this.getArg(path);
        if (arg != null) {
            try {
                if (arg.isList()) {
                    List args = (List)arg.getValue(action);
                    for (Argument argument : args) {
                        list.add(argument.getValue(action));
                    }
                } else if (arg.getValue(action) instanceof List) {
                    List argList = (List)arg.getValue(action);
                    for (Object object : argList) {
                        list.add(object);
                    }
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<VariableLink> getVarLinksList(String path, Action action) {
        ArrayList<VariableLink> list = new ArrayList<VariableLink>();
        Argument arg = this.getArg(path);
        if (arg != null && arg.isList()) {
            try {
                List args = (List)arg.getValue(action);
                for (Argument argument : args) {
                    Object object = argument.value;
                    if (!(object instanceof VariableLink)) continue;
                    VariableLink link = (VariableLink)object;
                    list.add(link);
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<String> getTextList(String path, Action action) {
        ArrayList<String> list = new ArrayList<String>();
        Argument arg = this.getArg(path);
        if (arg != null && arg.isList()) {
            try {
                List args = (List)arg.getValue(action);
                for (Argument textArg : args) {
                    Object textObject = textArg.getValue(action);
                    String textString = textObject.toString();
                    if (textObject instanceof ItemStack) {
                        ItemStack item = (ItemStack)textObject;
                        textString = item.hasItemMeta() && item.getItemMeta() != null ? item.getItemMeta().getDisplayName() : item.getType().name();
                    }
                    list.add(Argument.parseEntity(textString, action.getHandler().getMainActionHandler(), action));
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<Component> getComponentList(String path, Action action) {
        ArrayList<Component> list = new ArrayList<Component>();
        List<String> texts = this.getTextList(path, action);
        for (String text : texts) {
            list.add(this.textToComponent(text));
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<Double> getNumbersList(String path, Action action) {
        ArrayList<Double> list = new ArrayList<Double>();
        Argument arg = this.getArg(path);
        if (arg != null && arg.isList()) {
            try {
                List args = (List)arg.getValue(action);
                for (Argument numberArg : args) {
                    Object object = numberArg.getValue(action);
                    list.add(this.parseObject(object, 0.0));
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<ItemStack> getItemList(String path, Action action) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Argument arg = this.getArg(path);
        if (arg != null && arg.isList()) {
            try {
                List args = (List)arg.getValue(action);
                for (Argument itemArg : args) {
                    list.add((ItemStack)itemArg.getValue(action));
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public final List<Location> getLocationList(String path, Action action) {
        ArrayList<Location> list = new ArrayList<Location>();
        Argument arg = this.getArg(path);
        if (arg != null && arg.isList()) {
            try {
                List args = (List)arg.getValue(action);
                for (Argument itemArg : args) {
                    Object object = itemArg.getValue(action);
                    if (!(object instanceof Location)) continue;
                    Location loc = (Location)object;
                    loc.setWorld(this.planet.getTerritory().getWorld());
                    if (BlockUtils.isOutOfBorders(loc)) continue;
                    list.add(loc);
                }
            }
            catch (ClassCastException e) {
                return list;
            }
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, list);
        return list;
    }

    public VariableLink getVariableLink(String path, Action action) {
        Argument arg = this.getArg(path);
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
            return null;
        }
        Object object = arg.value;
        if (object instanceof VariableLink) {
            VariableLink link = (VariableLink)object;
            ErrorUtils.sendCodingDebugVariable(this.planet, path, link);
            return link;
        }
        ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        return null;
    }

    public Material getValue(String path, Material defaultValue, Action action) {
        Argument arg = this.getArg(path);
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
            return defaultValue;
        }
        Object object = arg.getValue(action);
        if (object instanceof ItemStack) {
            ItemStack item = (ItemStack)object;
            ErrorUtils.sendCodingDebugVariable(this.planet, path, item.getType());
            return item.getType();
        }
        object = arg.getValue(action);
        if (object instanceof Block) {
            Block block = (Block)object;
            ErrorUtils.sendCodingDebugVariable(this.planet, path, block.getType());
            return block.getType();
        }
        object = arg.getValue(action);
        if (object instanceof Location) {
            Location location = (Location)object;
            ErrorUtils.sendCodingDebugVariable(this.planet, path, location.getBlock().getType());
            return location.getBlock().getType();
        }
        ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        return defaultValue;
    }

    public ItemStack getValue(String path, ItemStack defaultValue, Action action) {
        Argument arg = this.getArg(path);
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
            return defaultValue;
        }
        if (arg.getValue(action) instanceof ItemStack) {
            ErrorUtils.sendCodingDebugVariable(this.planet, path, arg.getValue(action));
            return (ItemStack)arg.getValue(action);
        }
        ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        return defaultValue;
    }

    public boolean getValue(String path, boolean defaultValue, Action action) {
        Argument arg = this.getArg(path);
        boolean value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = this.parseObject(arg.getValue(action), defaultValue);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, value);
        }
        return value;
    }

    public Object getValue(String path, Action action) {
        Argument arg = this.getArg(path);
        Object value = "";
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = arg.getValue(action);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, value);
        }
        return value;
    }

    public int getValue(String path, int defaultValue, Action action) {
        Argument arg = this.getArg(path);
        int value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = this.parseObject(arg.getValue(action), defaultValue);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, value);
        }
        return value;
    }

    public long getValue(String path, long defaultValue, Action action) {
        Argument arg = this.getArg(path);
        long value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = this.parseObject(arg.getValue(action), defaultValue);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, value);
        }
        return value;
    }

    public Color getValue(String path, Color defaultValue, Action action) {
        Argument arg = this.getArg(path);
        Color value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            Object object = arg.getValue(action);
            if (object instanceof Color) {
                Color color;
                value = color = (Color)object;
                ErrorUtils.sendCodingDebugVariable(this.planet, path, color);
            }
        }
        return value;
    }

    public float getValue(String path, float defaultValue, Action action) {
        Argument arg = this.getArg(path);
        float value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = this.parseObject(arg.getValue(action), defaultValue);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, Float.valueOf(value));
        }
        return value;
    }

    public double getValue(String path, double defaultValue, Action action) {
        Argument arg = this.getArg(path);
        double value = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else {
            value = this.parseObject(arg.getValue(action), defaultValue);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, value);
        }
        return value;
    }

    public String getValue(String path, String defaultValue, Action action) {
        Argument arg = this.getArg(path);
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
            return defaultValue;
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, arg.getValue(action));
        return arg.getValue(action).toString();
    }

    public Component getValue(String path, Component defaultValue, Action action) {
        Argument arg = this.getArg(path);
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
            return defaultValue;
        }
        ErrorUtils.sendCodingDebugVariable(this.planet, path, arg.getValue(action));
        String text = arg.getValue(action).toString();
        return this.textToComponent(text);
    }

    public Component textToComponent(String text) {
        try {
            if (text.contains("\u00a7")) {
                return LegacyComponentSerializer.legacySection().deserialize(text);
            }
            Component miniMessage = MiniMessage.miniMessage().deserialize((Object)text);
            ClickEvent clickEvent = miniMessage.clickEvent();
            if (clickEvent != null && clickEvent.action() == ClickEvent.Action.RUN_COMMAND) {
                miniMessage = miniMessage.clickEvent(null);
            }
            return miniMessage;
        }
        catch (Exception exception) {
            return Component.text((String)text);
        }
    }

    public Particle getValue(String path, Particle defaultValue, Action action) {
        Object object;
        Argument arg = this.getArg(path);
        if (arg != null && (object = arg.getValue(action)) instanceof Particle) {
            Particle particle = (Particle)object;
            ErrorUtils.sendCodingDebugVariable(this.planet, path, arg.getValue(action));
            return particle;
        }
        ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        return defaultValue;
    }

    public char getValue(String path, char defaultValue, Action action) {
        String value;
        Argument arg = this.getArg(path);
        if (arg != null && (value = arg.getValue(action).toString()) != null && !value.isEmpty()) {
            ErrorUtils.sendCodingDebugVariable(this.planet, path, Character.valueOf(value.charAt(0)));
            return value.charAt(0);
        }
        ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        return defaultValue;
    }

    public Location getValue(String path, Location defaultValue, Action action) {
        Argument arg = this.getArg(path);
        Location locationValue = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else if (arg.getValue(action) instanceof Location) {
            locationValue = (Location)arg.getValue(action);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, locationValue.getX() + " " + locationValue.getY() + " " + locationValue.getZ() + " " + locationValue.getYaw() + " " + locationValue.getPitch());
        }
        locationValue.setWorld(this.planet.getTerritory().getWorld());
        if (BlockUtils.isOutOfBorders(locationValue)) {
            ErrorUtils.sendCodingDebugLog(this.planet, "Location is out of borders! " + String.valueOf(locationValue));
            return defaultValue;
        }
        return locationValue.clone();
    }

    public Vector getValue(String path, Vector defaultValue, Action action) {
        Argument arg = this.getArg(path);
        Vector vectionValue = defaultValue;
        if (arg == null) {
            ErrorUtils.sendCodingDebugNotFoundVariable(this.planet, path);
        } else if (arg.getValue(action) instanceof Vector) {
            vectionValue = (Vector)arg.getValue(action);
            ErrorUtils.sendCodingDebugVariable(this.planet, path, vectionValue.getX() + " " + vectionValue.getY() + " " + vectionValue.getZ());
        }
        return vectionValue;
    }

    private Object getVariableValue(VariableLink link, Action action) {
        return this.planet.getVariables().getVariableValue(link, action);
    }

    public int parseObject(Object object, int defaultValue) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Long.class, Double.class, Integer.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Float f = (Float)object3;
                yield f.intValue();
            }
            case 1 -> {
                Long l = (Long)object3;
                yield l.intValue();
            }
            case 2 -> {
                Double d = (Double)object3;
                yield d.intValue();
            }
            case 3 -> {
                Integer i = (Integer)object3;
                yield i;
            }
            case 4 -> {
                String s = (String)object3;
                yield NumberUtils.toInt((String)s, (int)defaultValue);
            }
            default -> defaultValue;
        };
    }

    public long parseObject(Object object, long defaultValue) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Long.class, Double.class, Integer.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Float f = (Float)object3;
                yield f.longValue();
            }
            case 1 -> {
                Long l = (Long)object3;
                yield l;
            }
            case 2 -> {
                Double d = (Double)object3;
                yield d.longValue();
            }
            case 3 -> {
                Integer i = (Integer)object3;
                yield i.longValue();
            }
            case 4 -> {
                String s = (String)object3;
                yield NumberUtils.toLong((String)s, (long)defaultValue);
            }
            default -> defaultValue;
        };
    }

    public boolean parseObject(Object object, boolean defaultValue) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Number.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Boolean b = (Boolean)object3;
                yield b;
            }
            case 1 -> {
                Number n = (Number)object3;
                if (this.parseObject((Object)n, defaultValue ? 2 : 1) > 1) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                String s = (String)object3;
                yield s.equalsIgnoreCase("true");
            }
            default -> defaultValue;
        };
    }

    public float parseObject(Object object, float defaultValue) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Long.class, Double.class, Integer.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Float f = (Float)object3;
                yield f.floatValue();
            }
            case 1 -> {
                Long l = (Long)object3;
                yield l.floatValue();
            }
            case 2 -> {
                Double d = (Double)object3;
                yield d.floatValue();
            }
            case 3 -> {
                Integer i = (Integer)object3;
                yield i.floatValue();
            }
            case 4 -> {
                String s = (String)object3;
                yield NumberUtils.toFloat((String)s, (float)defaultValue);
            }
            default -> defaultValue;
        };
    }

    public double parseObject(Object object, double defaultValue) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Float.class, Long.class, Double.class, Integer.class, String.class}, (Object)object3, n)) {
            case 0 -> {
                Float f = (Float)object3;
                yield f.doubleValue();
            }
            case 1 -> {
                Long l = (Long)object3;
                yield l.doubleValue();
            }
            case 2 -> {
                Double d = (Double)object3;
                yield d;
            }
            case 3 -> {
                Integer i = (Integer)object3;
                yield i.doubleValue();
            }
            case 4 -> {
                String s = (String)object3;
                yield NumberUtils.toDouble((String)s, (double)defaultValue);
            }
            default -> defaultValue;
        };
    }

    public void setArgumentValue(@NotNull String path, @NotNull ValueType type, @NotNull Object value) {
        if (path == null) {
            Arguments.$$$reportNull$$$0(24);
        }
        if (type == null) {
            Arguments.$$$reportNull$$$0(25);
        }
        if (value == null) {
            Arguments.$$$reportNull$$$0(26);
        }
        this.argumentList.removeIf(it -> path.equals(it.path));
        this.argumentList.add(new Argument(this.planet, type, path, value));
    }

    public void removeArgumentValue(String ... paths) {
        if (paths == null) {
            Arguments.$$$reportNull$$$0(27);
        }
        for (String path : paths) {
            this.argumentList.removeIf(it -> path.equals(it.path));
        }
    }

    @NotNull
    public List<Argument> getArgumentList() {
        List<Argument> list = this.argumentList;
        if (list == null) {
            Arguments.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/coding/arguments/Arguments";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/coding/arguments/Arguments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseValue";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: {
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setArgumentValue";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeArgumentValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 28 -> new IllegalStateException(string);
        };
    }
}

