/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.inventory;

import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class EntitySetItemInHandAction
extends EntityAction {
    public EntitySetItemInHandAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        LivingEntity living;
        ItemStack mainItem = this.getArguments().getValue("main", new ItemStack(Material.AIR), (Action)this);
        ItemStack offItem = this.getArguments().getValue("off", new ItemStack(Material.AIR), (Action)this);
        boolean replaceWithAir = this.getArguments().getValue("replace-with-air", false, (Action)this);
        if (entity instanceof HumanEntity) {
            HumanEntity human = (HumanEntity)entity;
            if (replaceWithAir || !mainItem.isEmpty()) {
                human.getInventory().setItemInMainHand(mainItem);
            }
            if (replaceWithAir || !offItem.isEmpty()) {
                human.getInventory().setItemInOffHand(offItem);
            }
        } else if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getEquipment() != null) {
            if (replaceWithAir || !mainItem.isEmpty()) {
                living.getEquipment().setItemInMainHand(mainItem);
            }
            if (replaceWithAir || !offItem.isEmpty()) {
                living.getEquipment().setItemInOffHand(offItem);
            }
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_SET_ITEM_IN_HAND;
    }
}

