/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.params;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class EntityGivePotionEffectsAction
extends EntityAction {
    public EntityGivePotionEffectsAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void execute(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        List<ItemStack> potionsItems = this.getArguments().getItemList("potions", this);
        boolean replace = this.getArguments().getValue("replace", true, (Action)this);
        for (ItemStack potionItem : potionsItems) {
            PotionMeta potionMeta = (PotionMeta)potionItem.getItemMeta();
            ArrayList effects = new ArrayList();
            if (potionMeta.getBasePotionType() != null) {
                effects.addAll(potionMeta.getBasePotionType().getPotionEffects());
            }
            if (potionMeta.hasCustomEffects()) {
                effects.addAll(potionMeta.getCustomEffects());
            }
            for (PotionEffect potionEffect : effects) {
                if (livingEntity.hasPotionEffect(potionEffect.getType()) && !replace) continue;
                livingEntity.addPotionEffect(potionEffect);
            }
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_GIVE_POTION_EFFECTS;
    }
}

