/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.params;

import java.util.List;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.entityactions.EntityAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooLongTextException;

public final class EntitySetNameAction
extends EntityAction {
    public EntitySetNameAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void execute(Entity entity) {
        if (entity instanceof Player) {
            return;
        }
        if (!this.getArguments().pathExists("name")) {
            entity.customName(null);
            return;
        }
        List<Component> components = this.getArguments().getComponentList("name", this);
        TextComponent.Builder builder = Component.text();
        for (Component component : components) {
            builder.append(component);
        }
        BuildableComponent name = builder.build();
        String plainText = PlainTextComponentSerializer.plainText().serialize((Component)name);
        int limit = OpenCreative.getSettings().getItemsMaxEntityNameLength();
        if (plainText.length() > limit) {
            throw new TooLongTextException(limit);
        }
        entity.customName((Component)name);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ENTITY_SET_CUSTOM_NAME;
    }
}

