/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.communication;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.PlayerPurchaseEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.menus.ConfirmationMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class RequestPurchaseAction
extends PlayerAction {
    public RequestPurchaseAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(final Player player) {
        final String id = this.getArguments().getValue("id", "example", (Action)this);
        final String name = this.getArguments().getValue("name", "Example", (Action)this);
        final boolean save = this.getArguments().getValue("save", false, (Action)this);
        final int price = this.getArguments().getValue("price", 100, (Action)this);
        final Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        if (planet == null) {
            return;
        }
        new ConfirmationMenu(MessageUtils.getLocaleMessage("menus.confirmation.request-money", false).replace("%name%", name), Material.GOLD_INGOT, MessageUtils.getLocaleItemName("menus.confirmation.items.request-money.name").replace("%price%", String.valueOf(price)).replace("%name%", name), MessageUtils.getLocaleItemDescription("menus.confirmation.items.request-money.lore"), new BukkitRunnable(this){

            public void run() {
                Planet currentPlanet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
                if (!planet.equals(currentPlanet) || !OpenCreative.getEconomy().isEnabled()) {
                    this.cancel();
                    return;
                }
                if (OpenCreative.getEconomy().getBalance((OfflinePlayer)player).intValue() < price) {
                    player.sendMessage(MessageUtils.getLocaleMessage("no-money").replace("%money%", String.valueOf(price)));
                } else {
                    if (save) {
                        if (planet.getWorldPlayers().getPlanetPlayer(player).getPurchases().contains(id.toLowerCase())) {
                            return;
                        }
                        planet.getWorldPlayers().getPlanetPlayer(player).addPurchase(id.toLowerCase());
                    }
                    Sounds.WORLD_PURCHASE.play((Audience)player);
                    if (!planet.isOwner(player)) {
                        OpenCreative.getEconomy().withdrawMoney((OfflinePlayer)player, price);
                        OpenCreative.getEconomy().depositMoney(Bukkit.getOfflinePlayer((String)planet.getOwner()), price);
                    }
                    new PlayerPurchaseEvent(player, id, name, price, save).callEvent();
                }
            }
        }).open(player);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_REQUEST_PURCHASE;
    }
}

