/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory;

import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooManyOpenedMenusException;

public final class OpenContainerAction
extends PlayerAction {
    public OpenContainerAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(Player player) {
        Location location = this.getArguments().getValue("location", this.getWorld().getSpawnLocation(), (Action)this);
        boolean save = this.getArguments().getValue("save", true, (Action)this);
        Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (blockState instanceof Container) {
            Container container = (Container)blockState;
            Inventory inventory = save ? container.getInventory() : this.copyInventory(container.getInventory(), container.customName());
            if (this.getPlanet().getLimits().cantOpenMenu(player)) {
                throw new TooManyOpenedMenusException(player.getName());
            }
            player.openInventory(inventory);
        } else if (block.getType() == Material.ENDER_CHEST) {
            Inventory inventory = save ? player.getEnderChest() : this.copyInventory(player.getEnderChest(), null);
            if (this.getPlanet().getLimits().cantOpenMenu(player)) {
                throw new TooManyOpenedMenusException(player.getName());
            }
            player.openInventory(inventory);
        } else if (block.getType() == Material.CRAFTING_TABLE) {
            player.openWorkbench(location, false);
        } else if (block.getType() == Material.ANVIL || block.getType() == Material.DAMAGED_ANVIL || block.getType() == Material.CHIPPED_ANVIL) {
            player.openAnvil(location, false);
        } else if (block.getType() == Material.CARTOGRAPHY_TABLE) {
            player.openCartographyTable(location, false);
        } else if (block.getType() == Material.ENCHANTING_TABLE) {
            player.openEnchanting(location, false);
        } else if (block.getType() == Material.LOOM) {
            player.openLoom(location, false);
        } else if (block.getType() == Material.GRINDSTONE) {
            player.openGrindstone(location, false);
        } else if (block.getType() == Material.SMITHING_TABLE) {
            player.openSmithingTable(location, false);
        } else if (block.getType() == Material.STONECUTTER) {
            player.openStonecutter(location, false);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_OPEN_CONTAINER;
    }

    private Inventory copyInventory(Inventory inventory, Component customName) {
        Component title = inventory.getType().defaultTitle();
        if (customName != null) {
            title = customName;
        }
        Inventory copiedInventory = Bukkit.createInventory(null, (int)inventory.getSize(), (Component)title);
        for (int slot = 0; slot < inventory.getSize() && slot < inventory.getContents().length; slot = (int)((byte)(slot + 1))) {
            ItemStack item = inventory.getItem(slot);
            if (item == null) continue;
            copiedInventory.setItem(slot, item);
        }
        return copiedInventory;
    }
}

