/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory;

import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.PlayerAction;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.playeractions.inventory.CustomMenu;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.exceptions.TooManyOpenedMenusException;

public final class SetMenuItemsRowAction
extends PlayerAction {
    public SetMenuItemsRowAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    public void executePlayer(Player player) {
        int i;
        if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof CustomMenu)) {
            return;
        }
        List<ItemStack> items = this.getArguments().getItemList("items", this);
        Inventory inventory = player.getOpenInventory().getTopInventory();
        if (inventory.getType() != InventoryType.CHEST && inventory.getType() != InventoryType.ENDER_CHEST) {
            return;
        }
        int row = this.getArguments().getValue("row", 1, (Action)this);
        if (row > 6) {
            row = 6;
        } else if (row < 1) {
            row = 1;
        }
        if (inventory.getSize() < row * 9) {
            inventory = new CustomMenu(row * 9, player.getOpenInventory().getTitle()).getInventory();
            if (this.getPlanet().getLimits().cantOpenMenu(player)) {
                throw new TooManyOpenedMenusException(player.getName());
            }
            player.openInventory(inventory);
        }
        boolean replaceWithAir = this.getArguments().getValue("replace-with-air", true, (Action)this);
        for (int slot = row * 9 - 9; slot < row * 9 && (i = slot % 9) < items.size(); ++slot) {
            ItemStack item = items.get(slot % 9);
            if (!replaceWithAir && item.isEmpty()) continue;
            player.getOpenInventory().getTopInventory().setItem(slot, item);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.PLAYER_SET_INVENTORY_VIEW_ROW_ITEMS;
    }
}

