/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.list;

import java.util.List;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.VariableAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.utils.millennium.math.Statistics;

public final class CalculateFromListAction
extends VariableAction {
    public CalculateFromListAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        VariableLink variable = this.getArguments().getVariableLink("variable", this);
        List elements = this.getArguments().getList("list", this);
        String type = this.getArguments().getValue("calculation", "get-min", (Action)this);
        if (elements != null && !elements.isEmpty() && elements.getFirst() instanceof Number) {
            List<Number> numbers = elements.stream().filter(o -> o instanceof Number).map(o -> (Number)o).toList();
            this.setVarValue(variable, switch (type) {
                case "get-min" -> Statistics.getMin(numbers);
                case "get-max" -> Statistics.getMax(numbers);
                case "average" -> Statistics.getAverage(numbers);
                case "variance" -> Statistics.getVariance(numbers);
                case "deviation" -> Statistics.getStandardDeviation(numbers);
                case "median" -> Statistics.getMedian(numbers);
                case "distinct" -> Statistics.getDistinct(numbers);
                case "kurtosis" -> Statistics.getKurtosis(numbers);
                case "skewness" -> Statistics.getSkewness(numbers);
                case "mode" -> Statistics.getMode(numbers);
                case "quantile" -> Statistics.getQuantile(numbers, 1.0);
                case "iqr" -> Statistics.getIQR(numbers);
                case "shannon-entropy" -> Statistics.getShannonEntropy(numbers);
                case "gini-index" -> Statistics.getGiniIndex(numbers);
                case "linear-trend" -> Statistics.getLinearTrend(numbers);
                case "jolt-delta-list" -> Statistics.getJiffDelta(numbers, 1);
                case "outliers-list" -> Statistics.getOutliersSimply(numbers);
                default -> 0;
            });
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.VAR_CALCULATE_FROM_LIST;
    }
}

