/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.number;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.noise.SimplexNoiseGenerator;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.VariableAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;

public final class SimplexNoiseAction
extends VariableAction {
    public SimplexNoiseAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        VariableLink link = this.getArguments().getVariableLink("variable", this);
        if (link == null) {
            return;
        }
        long seed = this.getArguments().getValue("seed", 1L, (Action)this);
        Location location = this.getArguments().getValue("location", this.getWorld().getSpawnLocation(), (Action)this);
        double lacunarity = this.getArguments().getValue("lacunarity", 1.0, (Action)this);
        int octaves = this.getArguments().getValue("octaves", 7, (Action)this);
        double frequency = this.getArguments().getValue("frequency", 0.5, (Action)this);
        double amplitude = this.getArguments().getValue("amplitude", -3.0, (Action)this);
        boolean normalize = this.getArguments().getValue("normalize", true, (Action)this);
        SimplexNoiseGenerator generator = new SimplexNoiseGenerator(seed);
        double result = generator.noise(location.getX() * lacunarity, location.getY() * lacunarity, location.getZ() * lacunarity, octaves, frequency, amplitude, normalize);
        this.setVarValue(link, result);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.VAR_NOISE_SIMPLEX;
    }
}

