/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.text;

import java.util.regex.Pattern;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.VariableAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;

public final class ParseNumberAction
extends VariableAction {
    private static final Pattern INT_PATTERN = Pattern.compile("^-?[0-9]*$");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^-?[0-9]*\\.?[0-9]+$");

    public ParseNumberAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        VariableLink link = this.getArguments().getVariableLink("variable", this);
        String text = this.getArguments().getValue("text", "0.0", (Action)this);
        if (INT_PATTERN.matcher(text).matches()) {
            this.setVarValue(link, Long.parseLong(text));
        } else if (FLOAT_PATTERN.matcher(text).matches()) {
            this.setVarValue(link, Double.parseDouble(text));
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.VAR_PARSE_NUMBER;
    }
}

