/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.vector;

import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.variableactions.VariableAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.coding.variables.VariableLink;
import ua.mcchickenstudio.opencreative.utils.async.AsyncScheduler;
import ua.mcchickenstudio.opencreative.utils.millennium.math.AxisAlignedBB;
import ua.mcchickenstudio.opencreative.utils.millennium.math.BuildSpeed;
import ua.mcchickenstudio.opencreative.utils.millennium.math.MovingObjectPosition;
import ua.mcchickenstudio.opencreative.utils.millennium.math.RayTrace;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2f;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class RayTraceVectorAction
extends VariableAction {
    public RayTraceVectorAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        VariableLink hitVec = this.getArguments().getVariableLink("hitVec", this);
        Vector vector = this.getArguments().getValue("vector", new Vector(0, 0, 0), (Action)this);
        Location from = this.getArguments().getValue("from", new Location(entity.getWorld(), 0.0, 0.0, 0.0), (Action)this);
        Location to = this.getArguments().getValue("to", new Location(entity.getWorld(), 0.0, 0.0, 0.0), (Action)this);
        double x = to.getX();
        double y = to.getY();
        double z = to.getZ();
        double range = this.getArguments().getValue("range", 3.0, (Action)this);
        double xSize = this.getArguments().getValue("xSize", 0.3, (Action)this) / 2.0;
        double ySize = this.getArguments().getValue("ySize", 1.8, (Action)this) / 2.0;
        double zSize = this.getArguments().getValue("zSize", 0.3, (Action)this) / 2.0;
        AsyncScheduler.run(() -> {
            BuildSpeed buildSpeed = this.getArguments().getValue("calculation", "vanilla-java", (Action)this).equals("vanilla-java") ? BuildSpeed.NORMAL : BuildSpeed.FAST;
            Vec2f rotation = RayTraceVectorAction.getYawPitch(vector);
            AxisAlignedBB aabb = new AxisAlignedBB(x - xSize, y - ySize, z - zSize, x + xSize, y + ySize, z + zSize);
            MovingObjectPosition result = RayTrace.rayCast(rotation.getX(), rotation.getY(), aabb, new Vec3(from.getX(), from.getY(), from.getZ()), range, buildSpeed);
            if (result == null) {
                this.setVarValue(hitVec, hitVec);
            } else {
                Vec3 hit = result.hitVec;
                this.setVarValue(hitVec, new Location(to.getWorld(), hit.xCoord, hit.yCoord, hit.zCoord));
            }
        }, AsyncScheduler.getScheduler());
    }

    public static Vec2f getYawPitch(Vector vector) {
        float pitch;
        float yaw;
        if (vector.getX() == 0.0 && vector.getZ() == 0.0) {
            yaw = 0.0f;
            pitch = vector.getY() > 0.0 ? -90.0f : 90.0f;
        } else {
            yaw = (float)Math.toDegrees(Math.atan2(-vector.getX(), vector.getZ()));
            double xz = Math.sqrt(vector.getX() * vector.getX() + vector.getZ() * vector.getZ());
            pitch = (float)Math.toDegrees(Math.atan(-vector.getY() / xz));
        }
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        return new Vec2f(yaw, pitch);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.VAR_DO_RAY_TRACE;
    }
}

