/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.appearance;

import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class BossBarOverlayAction
extends WorldAction {
    public BossBarOverlayAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("name")) {
            return;
        }
        String name = this.getArguments().getValue("name", "boss", (Action)this);
        String overlayString = this.getArguments().getValue("overlay", "progress", (Action)this);
        BossBar.Overlay overlay = BossBar.Overlay.PROGRESS;
        try {
            overlay = BossBar.Overlay.valueOf((String)overlayString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        BossBar bossBar = this.getPlanet().getTerritory().getBossBars().get(name.toLowerCase());
        if (bossBar != null) {
            bossBar.overlay(overlay);
        }
        this.getPlanet().getTerritory().getBossBars().put(name.toLowerCase(), bossBar);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_BOSS_BAR_PROGRESS;
    }
}

