/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.appearance;

import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Entity;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public final class CreateBossBarAction
extends WorldAction {
    public CreateBossBarAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("name")) {
            return;
        }
        String name = this.getArguments().getValue("name", "boss", (Action)this);
        String displayName = this.getArguments().getValue("display-name", " ", (Action)this);
        float progress = this.getArguments().getValue("progress", 100.0f, (Action)this) / 100.0f;
        String overlayString = this.getArguments().getValue("overlay", "progress", (Action)this);
        BossBar.Overlay overlay = BossBar.Overlay.PROGRESS;
        try {
            overlay = BossBar.Overlay.valueOf((String)overlayString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String colorString = this.getArguments().getValue("color", "purple", (Action)this);
        BossBar.Color color = BossBar.Color.PURPLE;
        try {
            color = BossBar.Color.valueOf((String)colorString.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.getPlanet().getTerritory().getBossBars().size() >= this.getPlanet().getLimits().getBossBarsLimit()) {
            ErrorUtils.sendCodingDebugLog(this.getPlanet(), "Limit of " + this.getPlanet().getLimits().getBossBarsLimit() + " boss bars reached.");
            return;
        }
        BossBar bossBar = this.getPlanet().getTerritory().getBossBars().get(name.toLowerCase());
        if (bossBar == null) {
            bossBar = BossBar.bossBar((Component)Component.text((String)displayName), (float)progress, (BossBar.Color)color, (BossBar.Overlay)overlay);
        } else {
            bossBar.name((Component)Component.text((String)displayName));
            bossBar.progress(progress);
            bossBar.overlay(overlay);
            bossBar.color(color);
        }
        this.getPlanet().getTerritory().getBossBars().put(name.toLowerCase(), bossBar);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_CREATE_BOSS_BAR;
    }
}

