/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.appearance;

import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class TeamSetCanSeeInvisibleAction
extends WorldAction {
    public TeamSetCanSeeInvisibleAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!this.getArguments().pathExists("scoreboard") || !this.getArguments().pathExists("team")) {
            return;
        }
        String scoreboardName = this.getArguments().getValue("scoreboard", "board", (Action)this);
        String teamName = this.getArguments().getValue("team", "team", (Action)this);
        Scoreboard scoreboard = this.getPlanet().getTerritory().getScoreboards().get(scoreboardName.toLowerCase());
        boolean visible = this.getArguments().getValue("visible", true, (Action)this);
        if (scoreboard == null) {
            return;
        }
        Team team = scoreboard.getTeam(teamName);
        if (team != null) {
            team.setCanSeeFriendlyInvisibles(visible);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_TEAM_SET_CAN_SEE_INVISIBLE;
    }
}

