/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import java.util.List;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;

public final class ClearContainerAction
extends WorldAction {
    public ClearContainerAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        List<Location> locations = this.getArguments().getLocationList("locations", this);
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                ClearContainerAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        this.getPlanet().getTerritory().addBukkitRunnable(runnable);
        for (Location location : locations) {
            if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
                runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
                this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
                new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
                return;
            }
            BlockState blockState = location.getBlock().getState();
            if (blockState instanceof InventoryHolder) {
                InventoryHolder container = (InventoryHolder)blockState;
                container.getInventory().clear();
            }
            this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
        }
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_CLEAR_CONTAINER;
    }
}

