/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.blocks;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.arguments.Arguments;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Action;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.Target;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.worldactions.WorldAction;
import ua.mcchickenstudio.opencreative.coding.blocks.events.world.other.LimitReachedBlocksEvent;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.Executor;
import ua.mcchickenstudio.opencreative.utils.BlockUtils;

public final class CopyBlocksAction
extends WorldAction {
    public CopyBlocksAction(Executor executor, Target target, int x, Arguments args) {
        super(executor, target, x, args);
    }

    @Override
    protected void execute(Entity entity) {
        if (!(this.getArguments().pathExists("first") && this.getArguments().pathExists("second") && this.getArguments().pathExists("from") && this.getArguments().pathExists("where"))) {
            return;
        }
        Location first = this.getArguments().getValue("first", this.getWorld().getSpawnLocation(), (Action)this);
        Location second = this.getArguments().getValue("second", this.getWorld().getSpawnLocation(), (Action)this);
        Location from = this.getArguments().getValue("from", this.getWorld().getSpawnLocation(), (Action)this);
        Location where = this.getArguments().getValue("where", this.getWorld().getSpawnLocation(), (Action)this);
        int minX = Math.min(first.getBlockX(), second.getBlockX());
        int minY = Math.min(first.getBlockY(), second.getBlockY());
        int minZ = Math.min(first.getBlockZ(), second.getBlockZ());
        int maxX = Math.max(first.getBlockX(), second.getBlockX());
        int maxY = Math.max(first.getBlockY(), second.getBlockY());
        int maxZ = Math.max(first.getBlockZ(), second.getBlockZ());
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                CopyBlocksAction.this.getPlanet().getLimits().setLastModifiedBlocksAmount(0);
            }
        };
        this.getPlanet().getTerritory().addBukkitRunnable(runnable);
        Vector whereFromSubtraction = where.subtract(from).toVector();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (this.getPlanet().getLimits().getLastModifiedBlocksAmount() > this.getPlanet().getLimits().getModifyingBlocksLimit()) {
                        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
                        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
                        new LimitReachedBlocksEvent(this.getPlanet()).callEvent();
                        return;
                    }
                    this.getPlanet().getLimits().setLastModifiedBlocksAmount(this.getPlanet().getLimits().getLastModifiedBlocksAmount() + 1);
                    Location oldLocation = new Location(this.getWorld(), (double)x, (double)y, (double)z);
                    Location newLocation = oldLocation.clone().add(whereFromSubtraction);
                    if (BlockUtils.isOutOfBorders(oldLocation) || BlockUtils.isOutOfBorders(newLocation)) continue;
                    Block newBlock = newLocation.getBlock();
                    newBlock.setType(oldLocation.getBlock().getType(), false);
                    newBlock.setBlockData(oldLocation.getBlock().getBlockData(), false);
                }
            }
        }
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 20L);
        this.getPlanet().getTerritory().removeBukkitRunnable(runnable);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.WORLD_COPY_BLOCKS;
    }
}

